/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.resources.ResourceLocation;

public class GuiUtils2 {
    public static final ResourceLocation WIDGETS_TEXTURE = AdAstraGiselleAddon.rl("textures/gui/widgets.png");
    public static final int WORKING_AREA_HEIGHT = 11;
    public static final int WORKING_AREA_SIDE_LEFT = 0;
    public static final int WORKING_AREA_SIDE_TOP = 0;
    public static final int WORKING_AREA_SIDE_WIDTH = 1;
    public static final int WORKING_AREA_MIDDLE_LEFT = 0;
    public static final int WORKING_AREA_MIDDLE_TOP = 1;
    public static final int WORKING_AREA_MIDDLE_WIDTH = 1;
    public static final int ARROW_LEFT = 0;
    public static final int ARROW_TOP = 11;
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;

    public static Rectangle getBounds(AbstractWidget widget) {
        return new Rectangle(widget.m_252754_(), widget.m_252907_(), widget.m_5711_(), widget.m_93694_());
    }

    public static boolean isHovering(Rectangle bounds, double x, double y) {
        return bounds.getMinX() <= x && x < bounds.getMaxX() && bounds.getMinX() <= y && y < bounds.getMaxY();
    }

    public static double getRatio(long amount, long total) {
        return total > 0L ? (double)amount / (double)total : 0.0;
    }

    public static Rectangle getArrowBounds(int x, int y) {
        return new Rectangle(x, y, 24, 17);
    }

    public static void drawHorizontal(GuiGraphics guiGraphics, int x, int y, int width, int height, ResourceLocation texture, int u, int v, long amount, long total) {
        GuiUtils2.drawHorizontal(guiGraphics, x, y, width, height, texture, u, v, GuiUtils2.getRatio(amount, total));
    }

    public static void drawHorizontal(GuiGraphics guiGraphics, int x, int y, int width, int height, ResourceLocation texture, int u, int v, double ratio) {
        int progress = (int)(ratio * (double)width);
        guiGraphics.m_280218_(texture, x, y, u, v, progress, height);
    }

    public static void drawVertical(GuiGraphics guiGraphics, int x, int y, int width, int height, ResourceLocation texture, int u, int v, long amount, long total) {
        GuiUtils2.drawVertical(guiGraphics, x, y, width, height, texture, u, v, GuiUtils2.getRatio(amount, total));
    }

    public static void drawVertical(GuiGraphics guiGraphics, int x, int y, int width, int height, ResourceLocation texture, int u, int v, double ratio) {
        int progress = (int)((1.0 - ratio) * (double)height);
        guiGraphics.m_280163_(texture, x, y + progress, (float)u, (float)(v + progress), width, height - progress, width, height);
    }

    public static void drawWorkingAreaBackground(GuiGraphics guiGraphics, Rectangle bounds) {
        int textureHeight = 11;
        int sideWidth = 1;
        int middleTextureWidth = 1;
        int x = bounds.x;
        int y = bounds.y;
        int height = bounds.height;
        int middleWidth = bounds.width - sideWidth * 2;
        guiGraphics.m_280163_(WIDGETS_TEXTURE, x, y, 0.0f, 0.0f, sideWidth, height, sideWidth, textureHeight);
        guiGraphics.m_280163_(WIDGETS_TEXTURE, x += sideWidth, y, 0.0f, 1.0f, middleWidth, height, middleTextureWidth, textureHeight);
        guiGraphics.m_280163_(WIDGETS_TEXTURE, x += middleWidth, y, 0.0f, 0.0f, sideWidth, height, sideWidth, textureHeight);
    }

    public static void drawArrow(GuiGraphics guiGraphics, int x, int y, long amount, long total) {
        GuiUtils2.drawHorizontal(guiGraphics, x, y, 24, 17, WIDGETS_TEXTURE, 0, 11, amount, total);
    }
}

