/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TackleBoxRenderer<T extends TackleBoxBlockEntity>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TACKLE_BOX_TEXTURE = new ResourceLocation("aquaculture", "textures/entity/tileentity/tackle_box.png");
    private static final RenderType TACKLE_BOX_RENDER = RenderType.m_110452_((ResourceLocation)TACKLE_BOX_TEXTURE);
    private final ModelPart base;
    private final ModelPart lid;

    public TackleBoxRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart part = context.m_173582_(ClientHandler.TACKLE_BOX);
        this.base = part.m_171324_("base");
        this.lid = part.m_171324_("lid");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition lid = partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-7.0f, -3.0f, -8.0f, 14.0f, 3.0f, 8.0f), PartPose.m_171419_((float)7.0f, (float)12.0f, (float)4.0f));
        partDefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(0.0f, -6.0f, -8.0f, 14.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)4.0f));
        lid.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171481_(-2.0f, -4.0f, -5.0f, 4.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void render(@Nonnull T tackleBox, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = tackleBox.m_58904_();
        boolean hasWorld = world != null;
        BlockState state = hasWorld ? tackleBox.m_58900_() : (BlockState)((Block)AquaBlocks.TACKLE_BOX.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        Block block = state.m_60734_();
        if (block instanceof TackleBoxBlock) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            float facing = ((Direction)state.m_61143_((Property)TackleBoxBlock.FACING)).m_122435_();
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-facing));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            matrixStack.m_252880_(0.0625f, 1.125f, 0.5f);
            matrixStack.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
            DoubleBlockCombiner.NeighborCombineResult callbackWrapper = DoubleBlockCombiner.Combiner::m_6502_;
            float angle = ((TackleBoxBlockEntity)((Object)tackleBox)).getOpenNess(partialTicks);
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            int brightness = ((Int2IntFunction)callbackWrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLight);
            VertexConsumer tackleBoxBuilder = buffer.m_6299_(TACKLE_BOX_RENDER);
            this.render(matrixStack, tackleBoxBuilder, this.base, this.lid, angle, brightness, combinedOverlay);
            matrixStack.m_85849_();
        }
    }

    private void render(PoseStack matrixStack, VertexConsumer builder, ModelPart base, ModelPart lid, float angle, int brightness, int combinedOverlay) {
        lid.f_104203_ = -(angle * 1.5707964f);
        base.m_104301_(matrixStack, builder, brightness, combinedOverlay);
        lid.m_104301_(matrixStack, builder, brightness, combinedOverlay);
        lid.m_104301_(matrixStack, builder, brightness, combinedOverlay);
    }
}

