/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class TurtleLandEntity
extends Animal {
    public TurtleLandEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new TurtleLandMovementController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TurtleLandSwimGoal());
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.05));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.15, this.getTurtleEdible(), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new GetOutOfWaterGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22284_, 1.5);
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return this.getTurtleEdible().test(stack);
    }

    public Ingredient getTurtleEdible() {
        return Ingredient.m_204132_(AquacultureAPI.Tags.TURTLE_EDIBLE);
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel world, @Nonnull AgeableMob ageableMob) {
        return (AgeableMob)this.m_6095_().m_20615_(this.m_9236_());
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.75f : size.f_20378_ * 0.7f;
    }

    static class TurtleLandMovementController
    extends MoveControl {
        private final TurtleLandEntity turtle;

        TurtleLandMovementController(TurtleLandEntity turtle) {
            super((Mob)turtle);
            this.turtle = turtle;
        }

        public void m_8126_() {
            super.m_8126_();
            this.updateSpeed();
        }

        private void updateSpeed() {
            if (this.turtle.m_20069_()) {
                if (this.turtle.m_6162_()) {
                    this.turtle.m_7910_(0.2f);
                } else {
                    this.turtle.m_7910_(0.18f);
                }
            } else if (this.turtle.m_20096_()) {
                this.turtle.m_7910_(0.1f);
            }
        }
    }

    public class TurtleLandSwimGoal
    extends FloatGoal {
        public TurtleLandSwimGoal() {
            super((Mob)TurtleLandEntity.this);
        }

        public boolean m_8036_() {
            return TurtleLandEntity.this.m_20069_() && TurtleLandEntity.this.m_204036_(FluidTags.f_13131_) > 0.1375 || TurtleLandEntity.this.m_20077_();
        }
    }

    static class GetOutOfWaterGoal
    extends MoveToBlockGoal {
        private final TurtleLandEntity turtle;

        private GetOutOfWaterGoal(TurtleLandEntity turtle) {
            super((PathfinderMob)turtle, turtle.m_6162_() ? 1.4 : 1.2, 24);
            this.turtle = turtle;
            this.f_25603_ = -1;
        }

        public void m_8037_() {
            super.m_8037_();
        }

        public boolean m_8045_() {
            return this.turtle.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            return this.turtle.m_20069_() && super.m_8036_();
        }

        protected boolean m_6465_(LevelReader reader, @Nonnull BlockPos pos) {
            Block block = reader.m_8055_(pos).m_60734_();
            return !(block instanceof LiquidBlock);
        }
    }
}

