/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.inventory.container;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.bait.IBaitItem;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotFishingRod;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotHidable;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TackleBoxContainer
extends AbstractContainerMenu {
    public TackleBoxBlockEntity tackleBox;
    private int rows = 4;
    private int collumns = 4;
    public Slot slotHook;
    public Slot slotBait;
    public Slot slotLine;
    public Slot slotBobber;

    public TackleBoxContainer(int windowID, BlockPos pos, Inventory playerInventory) {
        super((MenuType)AquaGuis.TACKLE_BOX.get(), windowID);
        this.tackleBox = (TackleBoxBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(pos);
        if (this.tackleBox != null) {
            this.tackleBox.startOpen(playerInventory.f_35978_);
            this.tackleBox.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                SlotFishingRod fishingRod = (SlotFishingRod)this.m_38897_((Slot)new SlotFishingRod((IItemHandler)handler, 0, 117, 21));
                this.slotHook = this.m_38897_((Slot)new SlotHidable(fishingRod, 0, 106, 44){

                    @Override
                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return stack.m_41720_() instanceof HookItem && super.m_5857_(stack);
                    }
                });
                this.slotBait = this.m_38897_((Slot)new SlotHidable(fishingRod, 1, 129, 44){

                    @Override
                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return stack.m_41720_() instanceof IBaitItem && super.m_5857_(stack);
                    }

                    @Override
                    public boolean m_8010_(Player player) {
                        return false;
                    }
                });
                this.slotLine = this.m_38897_((Slot)new SlotHidable(fishingRod, 2, 106, 67){

                    @Override
                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        boolean isDyeable = stack.m_41720_() instanceof DyeableLeatherItem;
                        return stack.m_204117_(AquacultureAPI.Tags.FISHING_LINE) && isDyeable && super.m_5857_(stack);
                    }
                });
                this.slotBobber = this.m_38897_((Slot)new SlotHidable(fishingRod, 3, 129, 67){

                    @Override
                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        boolean isDyeable = stack.m_41720_() instanceof DyeableLeatherItem;
                        return stack.m_204117_(AquacultureAPI.Tags.BOBBER) && isDyeable && super.m_5857_(stack);
                    }
                });
                for (int column = 0; column < this.collumns; ++column) {
                    for (int row = 0; row < this.rows; ++row) {
                        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1 + row + column * this.collumns, 8 + row * 18, 8 + column * 18){

                            public boolean m_5857_(@Nonnull ItemStack stack) {
                                return TackleBoxBlockEntity.canBePutInTackleBox(stack);
                            }
                        });
                    }
                }
            });
            for (int column = 0; column < 3; ++column) {
                for (int row = 0; row < 9; ++row) {
                    this.m_38897_(new Slot((Container)playerInventory, row + column * 9 + 9, 8 + row * 18, 90 + column * 18));
                }
            }
            for (int row = 0; row < 9; ++row) {
                this.m_38897_(new Slot((Container)playerInventory, row, 8 + row * 18, 148));
            }
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        return TackleBoxContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(this.tackleBox.m_58904_()), (BlockPos)this.tackleBox.m_58899_()), (Player)player, (Block)((Block)AquaBlocks.TACKLE_BOX.get()));
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack transferStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            transferStack = slotStack.m_41777_();
            if (index < this.rows * this.collumns ? !this.m_38903_(slotStack, this.rows * this.collumns, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.rows * this.collumns, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return transferStack;
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.tackleBox.stopOpen(player);
    }

    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickType, @Nonnull Player player) {
        ItemStack mouseStack;
        SlotItemHandler slotHandler;
        Slot slot;
        if (slotId >= 0 && clickType == ClickType.PICKUP && (slot = (Slot)this.f_38839_.get(slotId)) == this.slotBait && (slotHandler = (SlotItemHandler)slot).m_5857_(mouseStack = player.f_36096_.m_142621_()) && (slot.m_7993_().m_41768_() || slot.m_7993_().m_41619_() || slot.m_7993_().m_41720_() != mouseStack.m_41720_())) {
            slotHandler.m_5852_(ItemStack.f_41583_);
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }
}

