/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.util.JSONHelper;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.EnumUtils;

public class SerializerEnum<T extends Enum<T>>
implements ISerializer<T> {
    public final T defaultValue;
    private final Class<T> enumClass;

    public SerializerEnum(Class<T> enumClass) {
        this(enumClass, null);
    }

    public SerializerEnum(Class<T> enumClass, T defaultValue) {
        this.enumClass = enumClass;
        this.defaultValue = defaultValue;
    }

    @Override
    public T fromJSON(JsonElement json) {
        return this.getByName(JSONHelper.getAsString(json));
    }

    @Override
    public JsonElement toJSON(T toWrite) {
        return new JsonPrimitive(((Enum)toWrite).name());
    }

    @Override
    public T fromByteBuf(FriendlyByteBuf buffer) {
        return this.getByName(buffer.m_130277_());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, T toWrite) {
        buffer.m_130070_(((Enum)toWrite).name());
    }

    @Override
    public Tag toNBT(T toWrite) {
        return StringTag.m_129297_((String)((Enum)toWrite).name());
    }

    @Override
    public T fromNBT(Tag nbt) {
        if (nbt instanceof IntTag) {
            IntTag integer = (IntTag)nbt;
            return this.getByIndex(integer.m_7047_());
        }
        if (nbt instanceof StringTag) {
            StringTag stringTag = (StringTag)nbt;
            return this.getByName(stringTag.m_7916_());
        }
        throw new NBTParseException("Expected NBT to be a String tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }

    private T getByIndex(int index) {
        Enum[] values = (Enum[])this.enumClass.getEnumConstants();
        if (index < 0 || index > values.length) {
            throw new IndexOutOfBoundsException("Cannot read enum by index. Class: " + this.enumClass.getCanonicalName() + " Index: " + index + " Size: " + values.length);
        }
        return (T)values[index];
    }

    private T getByName(String name) {
        Enum value = EnumUtils.getEnum(this.enumClass, (String)name);
        if (value == null) {
            value = EnumUtils.getEnum(this.enumClass, (String)name.toUpperCase(Locale.ROOT));
        }
        if (value == null) {
            value = this.defaultValue;
        }
        return (T)value;
    }
}

