/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.fertilizer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.recipes.fertilizer.BasicFertilizer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class BasicFertilizerSerializer
implements RecipeSerializer<BasicFertilizer> {
    public static final RecipeSerializer<?> SERIALIZER = new BasicFertilizerSerializer();

    public BasicFertilizer fromJson(ResourceLocation id, JsonObject json) {
        Ingredient ingredient = (Ingredient)Serializers.INGREDIENT.fromJSON(json, "ingredient");
        Ingredient cropIngredient = (Ingredient)Serializers.INGREDIENT.fromJSONNullable(json, "crop_ingredient");
        Ingredient soilIngredient = (Ingredient)Serializers.INGREDIENT.fromJSONNullable(json, "soil_ingredient");
        int minTicks = (Integer)Serializers.INT.fromJSON(json, "min_growth");
        int maxTicks = (Integer)Serializers.INT.fromJSON(json, "max_growth");
        if (minTicks < 0 || maxTicks < 0) {
            throw new JsonParseException("Growth ticks must be greater than 0! min=" + minTicks + " max=" + maxTicks);
        }
        if (minTicks > maxTicks) {
            throw new JsonParseException("Min growth ticks must not be greater than max ticks.  min=" + minTicks + " max=" + maxTicks);
        }
        return new BasicFertilizer(id, ingredient, cropIngredient, soilIngredient, minTicks, maxTicks);
    }

    public BasicFertilizer fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        Ingredient ingredient = (Ingredient)Serializers.INGREDIENT.fromByteBuf(buffer);
        Ingredient cropIngredient = (Ingredient)Serializers.INGREDIENT.fromByteBufNullable(buffer);
        Ingredient soilIngredient = (Ingredient)Serializers.INGREDIENT.fromByteBufNullable(buffer);
        int minTicks = (Integer)Serializers.INT.fromByteBuf(buffer);
        int maxTicks = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new BasicFertilizer(id, ingredient, cropIngredient, soilIngredient, minTicks, maxTicks);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicFertilizer toWrite) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)toWrite.ingredient);
        Serializers.INGREDIENT.toByteBufNullable(buffer, (Object)toWrite.cropIngredient);
        Serializers.INGREDIENT.toByteBufNullable(buffer, (Object)toWrite.soilIngredient);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.minTicks);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.maxTicks);
    }
}

