/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.TipsyEffects;
import umpaz.brewinandchewin.client.gui.BnCHUDOverlays;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.client.gui.KegTooltip;
import umpaz.brewinandchewin.client.model.CoasterWrappedModel;
import umpaz.brewinandchewin.client.renderer.CoasterBlockEntityRenderer;
import umpaz.brewinandchewin.client.renderer.texture.BnCTextureModifiers;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;

@Mod.EventBusSubscriber(modid="brewinandchewin", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BnCClientSetup {
    private static final Set<ResourceLocation> MODELS = new HashSet<ResourceLocation>();

    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)BnCMenuTypes.KEG.get()), KegScreen::new));
        BnCHUDOverlays.init();
        TipsyEffects.init();
        BnCTextureModifiers.init();
    }

    @SubscribeEvent
    public static void registerCustomTooltipRenderers(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(KegTooltip.KegTooltipComponent.class, KegTooltip::new);
    }

    @SubscribeEvent
    public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)BnCFluidItemDisplays.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, pTintIndex) -> {
            BlockEntity patt3248$temp = level.m_7702_(pos);
            if (patt3248$temp instanceof CoasterBlockEntity) {
                CoasterBlockEntity blockEntity = (CoasterBlockEntity)patt3248$temp;
                int tintIndex = -1;
                int count = (int)blockEntity.getItems().stream().filter(i -> !i.m_41619_()).count();
                for (int i2 = 0; i2 < count; ++i2) {
                    ItemStack stack = (ItemStack)blockEntity.getItems().get(i2);
                    ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    List<CoasterBlockEntityRenderer.ModelEntry> modelEntries = CoasterBlockEntityRenderer.getModelEntries(itemId);
                    if (modelEntries == null) continue;
                    for (CoasterBlockEntityRenderer.ModelEntry modelEntry : modelEntries) {
                        int color = -1;
                        for (int j = 0; j < modelEntry.modifiers().size(); ++j) {
                            for (TextureModifier textureModifier : modelEntry.modifiers()) {
                                color = textureModifier.color(level, state, pos, stack, color);
                            }
                        }
                        if (color == -1 || ++tintIndex != pTintIndex) continue;
                        return color;
                    }
                }
            }
            return -1;
        }, new Block[]{(Block)BnCBlocks.COASTER.get()});
    }

    @SubscribeEvent
    public static void bakeModels(ModelEvent.RegisterAdditional event) {
        CoasterBlockEntityRenderer.resetCache();
        MODELS.addAll(BnCClientSetup.getModels(Minecraft.m_91087_().m_91098_(), Runnable::run));
        event.register(new ResourceLocation("brewinandchewin", "block/coaster"));
        event.register(new ResourceLocation("brewinandchewin", "block/coaster_tray"));
        for (ResourceLocation entry : MODELS) {
            event.register(entry);
        }
    }

    @SubscribeEvent
    public static void modifyBakingResult(ModelEvent.ModifyBakingResult event) {
        for (ResourceLocation entry : MODELS) {
            event.getModels().put(entry, new CoasterWrappedModel((BakedModel)event.getModels().get(entry)));
        }
        MODELS.clear();
    }

    public static List<ResourceLocation> getModels(ResourceManager manager, Executor executor) {
        ArrayList models = new ArrayList();
        for (Map.Entry resourceEntry : manager.m_214159_("brewinandchewin/coaster", fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            models.addAll(CompletableFuture.supplyAsync(() -> {
                try {
                    BufferedReader reader = ((Resource)resourceEntry.getValue()).m_215508_();
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    ((Reader)reader).close();
                    if (json instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)json;
                        ResourceLocation itemId = (ResourceLocation)((Pair)ResourceLocation.f_135803_.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("item")).getOrThrow(false, arg_0 -> ((Logger)BrewinAndChewin.LOG).error(arg_0))).getFirst();
                        List modelEntries = (List)((Pair)CoasterBlockEntityRenderer.ModelEntry.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("models")).getOrThrow(false, arg_0 -> ((Logger)BrewinAndChewin.LOG).error(arg_0))).getFirst();
                        CoasterBlockEntityRenderer.addToModelMap(itemId, modelEntries);
                        return modelEntries.stream().map(CoasterBlockEntityRenderer.ModelEntry::model).toList();
                    }
                }
                catch (Exception ex) {
                    BrewinAndChewin.LOG.error("Unexpected error in Brewin' And Chewin' coaster model JSON \"{}\". {}", resourceEntry.getKey(), (Object)ex);
                    return List.of();
                }
                BrewinAndChewin.LOG.error("Unexpected error in Brewin' And Chewin' coaster model JSON: {}.", resourceEntry.getKey());
                return List.of();
            }, executor).join());
        }
        return models.stream().filter(Objects::nonNull).toList();
    }
}

