/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipes;
import umpaz.brewinandchewin.integration.jei.category.CheeseRecipeCategory;
import umpaz.brewinandchewin.integration.jei.category.FermentingRecipeCategory;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransfer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("brewinandchewin", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FermentingRecipeCategory(registry.getJeiHelpers().getGuiHelper(), registry.getJeiHelpers().getModIdHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CheeseRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        BnCJEIRecipes modRecipes = new BnCJEIRecipes();
        registration.addRecipes(BnCJEIRecipeTypes.FERMENTING, modRecipes.getKegRecipes());
        registration.addRecipes(BnCJEIRecipeTypes.AGING, modRecipes.getCheeseRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BnCItems.KEG.get()), new RecipeType[]{BnCJEIRecipeTypes.FERMENTING});
    }

    public void registerGuiHandlers(final IGuiHandlerRegistration registration) {
        IIngredientHelper test = registration.getJeiHelpers().getIngredientManager().getIngredientHelper((IIngredientType)ForgeTypes.FLUID_STACK);
        registration.addRecipeClickArea(KegScreen.class, 80, 25, 23, 17, new RecipeType[]{BnCJEIRecipeTypes.FERMENTING});
        final Rect2i bounds = new Rect2i(107, 18, 26, 30);
        registration.addGuiContainerHandler(KegScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<KegScreen>(){

            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(final KegScreen containerScreen, double mouseX, double mouseY) {
                if (bounds.m_110087_((int)mouseX - containerScreen.getGuiLeft(), (int)mouseY - containerScreen.getGuiTop())) {
                    return Optional.of(new IClickableIngredient<FluidStack>(){

                        public ITypedIngredient<FluidStack> getTypedIngredient() {
                            Optional aef = registration.getJeiHelpers().getIngredientManager().createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)((KegMenu)containerScreen.m_6262_()).blockEntity.getFluidTank().getFluid());
                            return aef.orElse(null);
                        }

                        public Rect2i getArea() {
                            return bounds;
                        }
                    });
                }
                return Optional.empty();
            }
        });
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FermentingTransfer.Handler(registration.getTransferHelper(), registration.getJeiHelpers().getStackHelper()), BnCJEIRecipeTypes.FERMENTING);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

