/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife.compat.undergarden;

import java.util.List;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulTiers;
import net.brnbrd.delightful.common.item.knife.DKnifeItem;
import net.brnbrd.delightful.compat.Modid;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgottenKnifeItem
extends DKnifeItem {
    public ForgottenKnifeItem(Item.Properties properties) {
        super(DelightfulItemTags.ingot("forgotten_metal"), DelightfulTiers.FORGOTTEN, properties, Modid.UG);
        MinecraftForge.EVENT_BUS.addListener(this::onHurt);
        MinecraftForge.EVENT_BUS.addListener(this::onDig);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        Component name = super.m_7626_(stack);
        return this.enabled() ? name.m_6881_().m_130940_(ChatFormatting.GREEN) : name;
    }

    @Override
    public List<Component> getTools() {
        return List.of(Component.m_237115_((String)"tooltip.forgotten_sword").m_130940_(ChatFormatting.GREEN));
    }

    @Override
    public Modid[] getConflicts() {
        return new Modid[]{Modid.UGD};
    }

    @Override
    @Nullable
    public RecipeType<?> getRecipeType() {
        return RecipeType.f_44113_;
    }

    void onHurt(LivingHurtEvent e) {
        Player player;
        Entity entity;
        if (this.enabled() && (entity = e.getSource().m_7639_()) instanceof Player && (player = (Player)entity).m_21205_().m_150930_((Item)this) && ForgeRegistries.ENTITY_TYPES.getKey((Object)e.getEntity().m_6095_()).m_135827_().equals((Object)Modid.UG) && e.getEntity().m_6072_()) {
            e.setAmount(e.getAmount() * 1.5f);
        }
    }

    void onDig(PlayerEvent.BreakSpeed e) {
        BlockState state = e.getState();
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        if (this.enabled() && e.getEntity().m_21205_().m_150930_((Item)this) && state != null && Util.nameSpace((ItemLike)state.m_60734_()).equals((Object)Modid.UG)) {
            e.setNewSpeed(e.getOriginalSpeed() * 1.5f);
        }
    }
}

