/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.brnbrd.delightful.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

public class ReplaceLootModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.f_135803_.fieldOf("removed_item").forGetter(m -> m.removedItem), (App)ResourceLocation.f_135803_.fieldOf("added_item").forGetter(m -> m.addedItem))).apply((Applicative)inst, ReplaceLootModifier::new)));
    private final ResourceLocation removedItem;
    private final ResourceLocation addedItem;

    protected ReplaceLootModifier(LootItemCondition[] conditions, ResourceLocation removedItem, ResourceLocation addedItem) {
        super(conditions);
        this.removedItem = removedItem;
        this.addedItem = addedItem;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        if (Util.itemExists(this.removedItem) && Util.itemExists(this.addedItem)) {
            Item removed = Util.item(this.removedItem);
            Item added = Util.item(this.addedItem);
            if (removed != null && added != null) {
                ArrayList newLoot = Lists.newArrayList();
                generatedLoot.forEach(item -> {
                    if (item.m_150930_(removed)) {
                        ItemStack replacement = new ItemStack((ItemLike)added, item.m_41613_());
                        if (replacement.m_41613_() > replacement.m_41741_()) {
                            replacement.m_41764_(replacement.m_41741_());
                        }
                        newLoot.add(replacement);
                        generatedLoot.remove(item);
                    }
                });
                if (!newLoot.isEmpty()) {
                    generatedLoot.addAll((Collection)newLoot);
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

