/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.compat.botania;

import com.google.common.collect.Multimap;
import java.util.function.Supplier;
import net.brnbrd.delightful.compat.Modid;
import net.brnbrd.delightful.compat.botania.BotaniaLCP;
import net.brnbrd.delightful.network.DPacketHandler;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class BotaniaCompat {
    public static Supplier<Tier> manasteel() {
        return () -> BotaniaAPI.instance().getManasteelItemTier();
    }

    public static Supplier<Tier> elementium() {
        return () -> BotaniaAPI.instance().getElementiumItemTier();
    }

    public static Supplier<Tier> terrasteel() {
        return () -> BotaniaAPI.instance().getTerrasteelItemTier();
    }

    public static void sendServerMessage() {
        DPacketHandler.INSTANCE.sendToServer((Object)BotaniaLCP.INSTANCE);
    }

    public static int damageItemIfPossible(ItemStack stack, int amount, LivingEntity entity, int manaPerDamage) {
        return ToolCommons.damageItemIfPossible((ItemStack)stack, (int)amount, (LivingEntity)entity, (int)manaPerDamage);
    }

    public static boolean requestManaExactForTool(ItemStack stack, Player player, int manaToGet, boolean remove) {
        return ManaItemHandler.instance().requestManaExactForTool(stack, player, manaToGet, remove);
    }

    public static void handlePixies(Multimap<Attribute, AttributeModifier> ret, @NotNull EquipmentSlot slot) {
        ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlot)slot, (String)"Sword modifier", (double)0.05));
    }

    public static ManaBurstEntity getBurst(Player player, ItemStack stack, int manaPerDamage) {
        ManaBurstEntity burst = new ManaBurstEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(manaPerDamage);
        burst.setStartingMana(manaPerDamage);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
        burst.setSourceLens(Modid.MB.item("alfsteel_sword", BotaniaItems.terraSword).m_7968_().m_41777_());
        return burst;
    }

    public static ManaBurstEntity getAlfBurst(Player player, ItemStack stack, int manaPerDamage) {
        ManaBurstEntity burst = BotaniaCompat.getBurst(player, stack, manaPerDamage);
        burst.setColor(16224512);
        burst.setMana(manaPerDamage);
        burst.setStartingMana(manaPerDamage);
        burst.setMinManaLoss(20);
        burst.setManaLossPerTick(2.0f);
        return burst;
    }

    public static boolean trySpawnBurst(Player player, ItemStack stack, int manaPerDamage, float attackStr, boolean alf) {
        if (attackStr == 1.0f) {
            ManaBurstEntity burst = alf ? BotaniaCompat.getAlfBurst(player, stack, manaPerDamage) : BotaniaCompat.getBurst(player, stack, manaPerDamage);
            player.m_9236_().m_7967_((Entity)burst);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.terraBlade, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

