/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.container.loader.stage0;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.TypesafeMap;
import gg.essential.container.loader.stage0.EssentialLoader;
import gg.essential.container.loader.stage0.util.DelegatingTransformationServiceBase;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;

abstract class EssentialTransformationServiceBase
extends DelegatingTransformationServiceBase {
    private static final String STAGE1_CLS = "gg.essential.loader.stage1.EssentialTransformationService";

    public EssentialTransformationServiceBase(String variant) {
        super((ITransformationService stage0) -> EssentialTransformationServiceBase.loadStage1OrThrow(stage0, variant));
    }

    private static ITransformationService loadStage1OrThrow(ITransformationService stage0, String variant) {
        try {
            return EssentialTransformationServiceBase.loadStage1(stage0, variant);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ITransformationService loadStage1(ITransformationService stage0, String variant) throws Exception {
        Path gameDir = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElseGet(() -> Paths.get(".", new String[0]));
        EssentialLoader loader = new EssentialLoader(variant);
        Path stage1File = loader.loadStage1File(gameDir);
        URL stage1Url = stage1File.toUri().toURL();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{stage1Url}, stage0.getClass().getClassLoader());
        return (ITransformationService)Class.forName(STAGE1_CLS, true, classLoader).getConstructor(ITransformationService.class).newInstance(stage0);
    }
}

