/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastsuite;

import com.google.common.base.Stopwatch;
import dev.shadowsoffire.fastsuite.FastSuite;
import dev.shadowsoffire.fastsuite.StreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

class CachedRecipeList<C extends Container, T extends Recipe<C>> {
    static final Map<Class<?>, Boolean> parallelRecipeClassCache = Collections.synchronizedMap(new IdentityHashMap());
    static final Map<Class<?>, Boolean> ingredientClassCache = Collections.synchronizedMap(new IdentityHashMap());
    private final List<T> serialRecipes;
    private final List<T> parallelRecipes;
    private final RecipeType<T> type;

    public CachedRecipeList(RecipeType<T> type, Map<ResourceLocation, T> recipeMap) {
        this.type = type;
        this.serialRecipes = new ArrayList<T>();
        this.parallelRecipes = new ArrayList<T>();
        Stopwatch watch = Stopwatch.createStarted();
        for (Map.Entry<ResourceLocation, T> entry : recipeMap.entrySet()) {
            if (this.isParallelRecipe((Recipe)entry.getValue())) {
                this.parallelRecipes.add((Recipe)entry.getValue());
                continue;
            }
            this.serialRecipes.add((Recipe)entry.getValue());
        }
        watch.stop();
        FastSuite.LOGGER.info("Constructed recipe list for {} in {}. {}/{} recipes are parallelized.", (Object)ForgeRegistries.RECIPE_TYPES.getKey(type), (Object)watch, (Object)this.parallelRecipes.size(), (Object)recipeMap.size());
    }

    public Optional<T> getRecipeFor(C inv, Level level) {
        Optional parRecipe = StreamUtils.executeUntil(() -> this.parallelRecipes.parallelStream().filter(recipe -> recipe.m_5818_(inv, level)).findFirst(), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Optional.empty(), () -> CachedRecipeList.timeoutMsg(this.type));
        if (parRecipe.isPresent()) {
            return parRecipe;
        }
        for (Recipe recipe : this.serialRecipes) {
            if (!recipe.m_5818_(inv, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public List<T> getRecipesFor(C inv, Level level) {
        Comparator<Recipe> recipeSorter = Comparator.comparing(recipe -> recipe.m_8043_(level.m_9598_()).m_41778_());
        Predicate<Recipe> recipeFilter = recipe -> recipe.m_5818_(inv, level);
        List parallelList = StreamUtils.executeUntil(() -> this.parallelRecipes.parallelStream().filter(recipeFilter).collect(Collectors.toCollection(ArrayList::new)), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Collections.emptyList(), () -> CachedRecipeList.timeoutMsg(this.type));
        parallelList.addAll(this.serialRecipes.stream().filter(recipeFilter).toList());
        Collections.sort(parallelList, recipeSorter);
        return parallelList;
    }

    private boolean isParallelRecipe(T recipe) {
        if (!CachedRecipeList.isSafeRecipeClass(recipe.getClass())) {
            return false;
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (CachedRecipeList.isSafeIngredient(ingredient)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafeRecipeClass(Class<?> clz) {
        return parallelRecipeClassCache.computeIfAbsent(clz, c -> c.getName().startsWith("net.minecraft.world.item.crafting."));
    }

    private static boolean isSafeIngredient(Ingredient ingredient) {
        if (ingredient.isVanilla()) {
            return true;
        }
        return ingredientClassCache.computeIfAbsent(ingredient.getClass(), clz -> clz.getName().startsWith("net.minecraftforge.common.crafting."));
    }

    static String timeoutMsg(RecipeType<?> type) {
        return String.format("Multithreaded recipe lookup took longer than %d seconds - aborting and returning nothing. Consider blacklisting this recipe type (%s) in the config.", FastSuite.maxRecipeLookupTime, BuiltInRegistries.f_256990_.m_7981_(type));
    }
}

