/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.render.XYZ;
import xueluoanping.fluiddrawerslegacy.client.util.TankHolder;
import xueluoanping.fluiddrawerslegacy.client.util.TankRenderUtil;

public class FluidDrawerItemStackTileEntityRenderer
extends BlockEntityWithoutLevelRenderer {
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;

    public FluidDrawerItemStackTileEntityRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.blockEntityRenderDispatcher = renderDispatcher;
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel ibakedmodel = itemRenderer.m_174264_(stack, (Level)null, (LivingEntity)null, 0);
        matrixStackIn.m_85836_();
        this.renderFluid(stack, matrixStackIn, bufferIn, combinedLightIn, 0.0);
        matrixStackIn.m_252880_(0.5f, 0.5f, 0.5f);
        itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, matrixStackIn, bufferIn, combinedLightIn, combinedOverlay, ibakedmodel.applyTransform(ItemDisplayContext.NONE, matrixStackIn, false));
        matrixStackIn.m_85849_();
    }

    private PoseStack rotateMatrix(PoseStack matrixStackIn, ItemDisplayContext transformType) {
        if (transformType == ItemDisplayContext.GUI) {
            matrixStackIn.m_252880_(0.9375f, 0.21875f, 0.0f);
            matrixStackIn.m_252781_(XYZ.deg_to_rad(30, 225, 0));
            matrixStackIn.m_85841_(0.625f, 0.625f, 0.625f);
        }
        if (transformType == ItemDisplayContext.GROUND) {
            matrixStackIn.m_85837_(0.375, 0.375, 0.375);
            matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            matrixStackIn.m_252781_(XYZ.deg_to_rad(75, 45, 0));
            matrixStackIn.m_85837_(0.51625, 0.46875, -0.1875);
            matrixStackIn.m_85841_(0.375f, 0.375f, 0.375f);
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            matrixStackIn.m_252781_(XYZ.deg_to_rad(75, 45, 0));
            matrixStackIn.m_85837_(0.51625, 0.46875, -0.1875);
            matrixStackIn.m_85841_(0.375f, 0.375f, 0.375f);
        }
        if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            matrixStackIn.m_85837_(0.40625, -0.1875, 0.0);
            matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 45, 0));
            matrixStackIn.m_85841_(0.675f, 0.675f, 0.675f);
        }
        if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            matrixStackIn.m_85837_(0.59375, -0.1875, 0.0);
            matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 225, 0));
            matrixStackIn.m_85841_(0.675f, 0.675f, 0.675f);
        }
        return matrixStackIn;
    }

    private void renderFluid(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime) {
        if (!stack.m_41784_().m_128441_("tank") && !stack.m_41784_().m_128441_("tanks")) {
            return;
        }
        FluidStack fluidStackDown = new FluidStack(Fluids.f_76191_, 0);
        if (stack.m_41784_().m_128441_("tank")) {
            ListTag tanklist = new ListTag();
            tanklist.add((Object)stack.m_41784_().m_128469_("tank"));
            stack.m_41784_().m_128365_("tanks", (Tag)tanklist);
        }
        ArrayList<TankHolder> flist = new ArrayList<TankHolder>();
        if (stack.m_41784_().m_128441_("tanks")) {
            for (Tag tank : stack.m_41784_().m_128437_("tanks", 10)) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)tank));
                int capacity = BlockEntityFluidDrawer.calculateTankCapacityFromStack(stack);
                if (!fluidStack.isEmpty() && stack.m_41784_().toString().contains("storagedrawers:creative_vending_upgrade")) {
                    fluidStack.setAmount(capacity);
                }
                flist.add(TankRenderUtil.of(fluidStack, capacity));
            }
        }
        TankRenderUtil.renderFluid(flist, matrixStackIn, bufferIn, combinedLight, animationTime, stack.m_41720_().m_5524_().contains("half"));
    }
}

