/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.util.Utils;

public final class QuadTable
implements QuadMap {
    private static final int LAYER_COUNT = RenderType.m_110506_().size();
    static final int SIDE_COUNT = Direction.values().length + 1;
    private static final Direction[] SIDES = (Direction[])Stream.concat(Arrays.stream(Direction.values()), Stream.of((Direction)null)).toArray(Direction[]::new);
    private static final List<BakedQuad> EMPTY = List.of();
    private final ArrayList<BakedQuad>[] quads = new ArrayList[LAYER_COUNT * SIDE_COUNT];
    private int boundBaseIdx = -1;

    public List<BakedQuad> getQuads(RenderType renderType, Direction side) {
        int idx = renderType.getChunkLayerId() * SIDE_COUNT + Utils.maskNullDirection(side);
        return Objects.requireNonNullElse(this.quads[idx], EMPTY);
    }

    @Override
    public ArrayList<BakedQuad> get(Direction side) {
        Preconditions.checkState((this.boundBaseIdx > -1 ? 1 : 0) != 0, (Object)"No RenderType bound");
        return this.quads[this.boundBaseIdx + Utils.maskNullDirection(side)];
    }

    @Override
    public ArrayList<BakedQuad> put(Direction side, ArrayList<BakedQuad> quadList) {
        Preconditions.checkState((this.boundBaseIdx > -1 ? 1 : 0) != 0, (Object)"No RenderType bound");
        int idx = this.boundBaseIdx + Utils.maskNullDirection(side);
        ArrayList<BakedQuad> oldList = this.quads[idx];
        this.quads[idx] = quadList;
        return oldList;
    }

    public void initializeForLayer(RenderType renderType) {
        this.bindRenderType(renderType);
        int end = this.boundBaseIdx + SIDE_COUNT;
        for (int i = this.boundBaseIdx; i < end; ++i) {
            this.quads[i] = new ArrayList();
        }
    }

    public void bindRenderType(RenderType renderType) {
        this.boundBaseIdx = renderType != null ? renderType.getChunkLayerId() * SIDE_COUNT : -1;
    }

    @Override
    @Deprecated
    @NotNull
    public Set<Direction> keySet() {
        return Arrays.stream(SIDES).collect(Collectors.toSet());
    }

    @Override
    @Deprecated
    @NotNull
    public Collection<List<BakedQuad>> values() {
        return Arrays.stream(SIDES).map(this::get).map(l -> l).toList();
    }

    @Override
    @Deprecated
    @NotNull
    public Set<Map.Entry<Direction, List<BakedQuad>>> entrySet() {
        return Arrays.stream(SIDES).map(dir -> new QuadEntry((Direction)dir, (List<BakedQuad>)this.get((Direction)dir))).collect(Collectors.toSet());
    }

    private record QuadEntry(Direction dir, List<BakedQuad> quads) implements Map.Entry<Direction, List<BakedQuad>>
    {
        @Override
        public Direction getKey() {
            return this.dir;
        }

        @Override
        public List<BakedQuad> getValue() {
            return this.quads;
        }

        @Override
        public List<BakedQuad> setValue(List<BakedQuad> value) {
            ArrayList<BakedQuad> oldQuads = new ArrayList<BakedQuad>(this.quads);
            this.quads.clear();
            this.quads.addAll(value);
            return oldQuads;
        }
    }
}

