/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.ConcatenatedListView;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockStateCache;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDoubleBlockModel
extends BakedModelProxy {
    private static final ModelData EMPTY_FRAME = FramedDoubleBlockModel.makeDefaultData(false);
    private static final ModelData EMPTY_ALT_FRAME = FramedDoubleBlockModel.makeDefaultData(true);
    private final boolean specialItemModel;
    private final DoubleBlockTopInteractionMode particleMode;
    private final Vec3 handTransform;
    private final Tuple<BlockState, BlockState> dummyStates;
    private Tuple<BakedModel, BakedModel> models = null;

    public FramedDoubleBlockModel(BlockState state, BakedModel baseModel, Vec3 handTransform, boolean specialItemModel) {
        super(baseModel);
        DoubleBlockStateCache cache = ((IFramedDoubleBlock)state.m_60734_()).getCache(state);
        this.dummyStates = cache.getBlockPair();
        this.particleMode = cache.getTopInteractionMode();
        this.handTransform = handTransform;
        this.specialItemModel = specialItemModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType layer) {
        ArrayList<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(2);
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)extraData.get(FramedDoubleBlockEntity.DATA_LEFT), EMPTY_FRAME);
        quads.add(((BakedModel)models.m_14418_()).getQuads((BlockState)this.dummyStates.m_14418_(), side, rand, dataLeft, layer));
        ModelData dataRight = Objects.requireNonNullElse((ModelData)extraData.get(FramedDoubleBlockEntity.DATA_RIGHT), EMPTY_ALT_FRAME);
        quads.add(FramedDoubleBlockModel.invertTintIndizes(((BakedModel)models.m_14419_()).getQuads((BlockState)this.dummyStates.m_14419_(), side, rand, dataRight, layer)));
        return ConcatenatedListView.of(quads);
    }

    @Override
    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        if (this.specialItemModel) {
            return this.getQuads(state, side, rand, ModelData.EMPTY, RenderType.m_110463_());
        }
        return super.m_213637_(state, side, rand);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return switch (this.particleMode) {
            default -> throw new IncompatibleClassChangeError();
            case DoubleBlockTopInteractionMode.FIRST -> this.getSpriteOrDefault(data, false);
            case DoubleBlockTopInteractionMode.SECOND -> this.getSpriteOrDefault(data, true);
            case DoubleBlockTopInteractionMode.EITHER -> {
                TextureAtlasSprite sprite = this.getSprite(data, false);
                if (sprite != null) {
                    yield sprite;
                }
                sprite = this.getSprite(data, true);
                if (sprite != null) {
                    yield sprite;
                }
                yield this.baseModel.m_6160_();
            }
        };
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT), ModelData.EMPTY);
        ModelData dataRight = Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_RIGHT), ModelData.EMPTY);
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{((BakedModel)models.m_14418_()).getRenderTypes((BlockState)this.dummyStates.m_14418_(), rand, dataLeft), ((BakedModel)models.m_14419_()).getRenderTypes((BlockState)this.dummyStates.m_14419_(), rand, dataRight)});
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileData) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)tileData.get(FramedDoubleBlockEntity.DATA_LEFT), ModelData.EMPTY);
        ModelData dataRight = Objects.requireNonNullElse((ModelData)tileData.get(FramedDoubleBlockEntity.DATA_RIGHT), ModelData.EMPTY);
        dataLeft = ((BakedModel)models.m_14418_()).getModelData(level, pos, (BlockState)this.dummyStates.m_14418_(), dataLeft);
        dataRight = ((BakedModel)models.m_14419_()).getModelData(level, pos, (BlockState)this.dummyStates.m_14419_(), dataRight);
        return tileData.derive().with(FramedDoubleBlockEntity.DATA_LEFT, (Object)dataLeft).with(FramedDoubleBlockEntity.DATA_RIGHT, (Object)dataRight).build();
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        if (this.handTransform != null) {
            poseStack.m_85837_(this.handTransform.f_82479_, this.handTransform.f_82480_, this.handTransform.f_82481_);
        }
    }

    protected final Tuple<BakedModel, BakedModel> getModels() {
        if (this.models == null) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            this.models = new Tuple((Object)dispatcher.m_110910_((BlockState)this.dummyStates.m_14418_()), (Object)dispatcher.m_110910_((BlockState)this.dummyStates.m_14419_()));
        }
        return this.models;
    }

    protected final TextureAtlasSprite getSpriteOrDefault(ModelData data, boolean secondary) {
        TextureAtlasSprite sprite = this.getSprite(data, secondary);
        return sprite != null ? sprite : this.baseModel.m_6160_();
    }

    protected final TextureAtlasSprite getSprite(ModelData data, boolean secondary) {
        FramedBlockData fbData;
        ModelData innerData = (ModelData)data.get(secondary ? FramedDoubleBlockEntity.DATA_RIGHT : FramedDoubleBlockEntity.DATA_LEFT);
        if (innerData != null && (fbData = (FramedBlockData)innerData.get(FramedBlockData.PROPERTY)) != null && !fbData.getCamoState().m_60795_()) {
            BakedModel model = secondary ? (BakedModel)this.getModels().m_14419_() : (BakedModel)this.getModels().m_14418_();
            return model.getParticleIcon(innerData);
        }
        return null;
    }

    private static List<BakedQuad> invertTintIndizes(List<BakedQuad> quads) {
        ArrayList<BakedQuad> inverted = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            inverted.add(ModelUtils.invertTintIndex(quad));
        }
        return inverted;
    }

    private static ModelData makeDefaultData(boolean altModel) {
        FramedBlockData.Immutable data = new FramedBlockData.Immutable(Blocks.f_50016_.m_49966_(), new boolean[6], altModel);
        return ModelData.builder().with(FramedBlockData.PROPERTY, (Object)data).build();
    }
}

