/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedPressurePlateModel
extends FramedBlockModel {
    private final boolean pressed;

    public FramedPressurePlateModel(BlockState state, BakedModel baseModel) {
        this(state, baseModel, (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_));
    }

    protected FramedPressurePlateModel(BlockState state, BakedModel baseModel, boolean powered) {
        super(state, baseModel);
        this.pressed = powered;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        float height;
        Direction quadDir = quad.m_111306_();
        float f = height = this.pressed ? 0.03125f : 0.0625f;
        if (Utils.isY(quadDir)) {
            boolean up = quadDir == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).applyIf(Modifiers.setPosition(height), up).export(quadMap.get(up ? null : Direction.DOWN));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0625f, 0.0f, 0.9375f, height)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
    }

    @Override
    protected boolean useBaseModel() {
        return !this.state.m_60713_((Block)FBContent.BLOCK_FRAMED_PRESSURE_PLATE.get()) && !this.state.m_60713_((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_PRESSURE_PLATE.get());
    }
}

