/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.special;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.special.FramingSawBlock;
import xfacthd.framedblocks.common.blockentity.special.PoweredFramingSawBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.menu.PoweredFramingSawMenu;

public class PoweredFramingSawBlock
extends FramingSawBlock
implements EntityBlock {
    public static final Component POWERED_SAW_MENU_TITLE = Utils.translate("title", "powered_framing_saw");

    public PoweredFramingSawBlock() {
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.ACTIVE});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return FramingSawBlock.SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (newState.m_60734_() != state.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof PoweredFramingSawBlockEntity) {
            PoweredFramingSawBlockEntity be = (PoweredFramingSawBlockEntity)blockEntity;
            be.dropContents(stack -> PoweredFramingSawBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PoweredFramingSawBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_()) {
            return Utils.createBlockEntityTicker(type, FBContent.BE_TYPE_POWERED_FRAMING_SAW.get(), PoweredFramingSawBlockEntity::tick);
        }
        return null;
    }

    @Override
    protected Component getSawMenuTitle() {
        return POWERED_SAW_MENU_TITLE;
    }

    @Override
    protected AbstractContainerMenu createSawMenu(int containerId, Inventory inventory, Level level, BlockPos pos) {
        return new PoweredFramingSawMenu(containerId, inventory, level, pos);
    }
}

