/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record HorizontalAxisComponent(boolean oppose) implements KBlockComponent
{
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private static final HorizontalAxisComponent NORMAL = new HorizontalAxisComponent(false);
    private static final HorizontalAxisComponent OPPOSE = new HorizontalAxisComponent(true);
    public static final MapCodec<HorizontalAxisComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("oppose", (Object)false).forGetter(HorizontalAxisComponent::oppose)).apply((Applicative)instance, HorizontalAxisComponent::getInstance));

    public static HorizontalAxisComponent getInstance(boolean oppose) {
        return oppose ? OPPOSE : NORMAL;
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.HORIZONTAL_AXIS.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (settings.customPlacement) {
            return state;
        }
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_().m_122478_() || !(blockstate = (BlockState)state.m_61124_(AXIS, (Comparable)(this.oppose ? direction : direction.m_122427_()).m_122434_())).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return switch (pRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)pState.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield pState;
            }
            default -> pState;
        };
    }
}

