/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.loader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.loader.AnnotatedTypeLoader;
import snownee.kiwi.loader.KiwiConfiguration;
import snownee.kiwi.network.KiwiPacket;

public class DevEnvAnnotatedTypeLoader
extends AnnotatedTypeLoader {
    public DevEnvAnnotatedTypeLoader(String modId) {
        super(modId);
    }

    @Override
    public KiwiConfiguration get() {
        IModFileInfo modFileInfo = ModList.get().getModFileById(this.modId);
        if (modFileInfo == null) {
            return null;
        }
        Type KIWI_MODULE = Type.getType(KiwiModule.class);
        Type KIWI_CONFIG = Type.getType(KiwiConfig.class);
        Type KIWI_PACKET = Type.getType(KiwiPacket.class);
        Type OPTIONAL_MODULE = Type.getType(KiwiModule.Optional.class);
        Type LOADING_CONDITION = Type.getType(KiwiModule.LoadingCondition.class);
        KiwiConfiguration configuration = new KiwiConfiguration();
        configuration.conditions = Lists.newArrayList();
        configuration.optionals = Lists.newArrayList();
        configuration.modules = Lists.newArrayList();
        configuration.packets = Lists.newArrayList();
        configuration.configs = Lists.newArrayList();
        for (ModFileScanData.AnnotationData annotationData : modFileInfo.getFile().getScanResult().getAnnotations()) {
            Type annotationType = annotationData.annotationType();
            if (KIWI_MODULE.equals((Object)annotationType)) {
                configuration.modules.add(DevEnvAnnotatedTypeLoader.map(annotationData));
                continue;
            }
            if (KIWI_CONFIG.equals((Object)annotationData.annotationType())) {
                configuration.configs.add(DevEnvAnnotatedTypeLoader.map(annotationData));
                continue;
            }
            if (OPTIONAL_MODULE.equals((Object)annotationType)) {
                configuration.optionals.add(DevEnvAnnotatedTypeLoader.map(annotationData));
                continue;
            }
            if (LOADING_CONDITION.equals((Object)annotationType)) {
                KiwiAnnotationData mapped = DevEnvAnnotatedTypeLoader.map(annotationData);
                String methodName = annotationData.memberName();
                int p = methodName.indexOf(40);
                if (p <= 0) {
                    throw new IllegalArgumentException();
                }
                methodName = methodName.substring(0, p);
                mapped.data().put("method", methodName);
                configuration.conditions.add(mapped);
                continue;
            }
            if (!KIWI_PACKET.equals((Object)annotationType)) continue;
            configuration.packets.add(DevEnvAnnotatedTypeLoader.map(annotationData));
        }
        return configuration;
    }

    private static KiwiAnnotationData map(ModFileScanData.AnnotationData data) {
        HashMap annotationData = Maps.newHashMap();
        for (Map.Entry e : data.annotationData().entrySet()) {
            if (e.getValue() instanceof ModAnnotation.EnumHolder) {
                annotationData.put((String)e.getKey(), ((ModAnnotation.EnumHolder)e.getValue()).getValue());
                continue;
            }
            annotationData.put((String)e.getKey(), e.getValue());
        }
        return new KiwiAnnotationData(data.clazz().getClassName(), annotationData);
    }
}

