/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import com.google.gson.JsonObject;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.recipes.IngredientSerializer;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorIngredient;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorList;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorStackList;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorTagList;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.DyedRecipeSerializer;
import java.util.Comparator;
import java.util.TreeMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ColorIngredientSerializer
implements IngredientSerializer<ColorIngredient> {
    @Override
    @NotNull
    public String getRegistryName() {
        return "color";
    }

    @NotNull
    public ColorIngredient parse(@NotNull FriendlyByteBuf buffer) {
        if (buffer.readInt() == 0) {
            return new ColorIngredient(new ColorStackList(buffer.m_130267_()));
        }
        TreeMap<ItemStack, Color> colorStacks = new TreeMap<ItemStack, Color>(Comparator.comparing(o -> BuiltInRegistries.f_257033_.m_7981_((Object)o.m_41720_())));
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            colorStacks.put(buffer.m_130267_(), Color.values()[buffer.readInt()]);
        }
        return new ColorIngredient(new ColorTagList(colorStacks));
    }

    @NotNull
    public ColorIngredient parse(@NotNull JsonObject json) {
        return (ColorIngredient)new DyedRecipeSerializer().deserializeIngredient(json);
    }

    public void write(@NotNull FriendlyByteBuf buffer, @NotNull ColorIngredient ingredient) {
        ColorList colorList = ingredient.getIngrediant();
        if (colorList instanceof ColorStackList) {
            buffer.writeInt(0);
            buffer.m_130055_(((ColorStackList)colorList).getItemStack());
        } else {
            buffer.writeInt(1);
            TreeMap<ItemStack, Color> colorStacks = ((ColorTagList)colorList).getColorStacks();
            buffer.writeInt(colorStacks.size());
            colorStacks.forEach((stack, color) -> {
                buffer.m_130055_(stack);
                buffer.writeInt(color.ordinal());
            });
        }
    }
}

