/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.special.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.ResourceLocationException;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JSONUtil {
    private static final Logger log = LogManager.getLogger(JSONUtil.class);
    @NotNull
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static String getStringFromJson(@NotNull JsonObject jsonObject, @NotNull String key) {
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonPrimitive()) {
            return element.getAsJsonPrimitive().getAsString();
        }
        return null;
    }

    public static JsonObject getJsonObjectFromJson(@NotNull JsonObject jsonObject, @NotNull String key) {
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonObject()) {
            return element.getAsJsonObject();
        }
        return null;
    }

    @NotNull
    public static ItemStack readItemStackFromJson(@NotNull JsonObject jsonObject) {
        try {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)jsonObject, (boolean)true);
            stack.m_41764_(1);
            return stack;
        }
        catch (JsonSyntaxException | ResourceLocationException exception) {
            log.error("Failed to load ItemStack", exception);
            return ItemStack.f_41583_;
        }
    }
}

