/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.functions;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;

public class ConstantPredicates {
    private static final Predicate<Object> alwaysTrue = t -> true;
    private static final BiPredicate<Object, Object> alwaysTrueBi = (t, u) -> true;
    private static final TriPredicate<Object, Object, Object> alwaysTrueTri = (t, u, v) -> true;
    private static final Predicate<Object> alwaysFalse = t -> false;
    private static final BiPredicate<Object, Object> alwaysFalseBi = (t, u) -> false;
    private static final TriPredicate<Object, Object, Object> alwaysFalseTri = (t, u, v) -> false;
    private static final BiPredicate<Object, @NotNull AutomationType> internalOnly = (t, automationType) -> automationType == AutomationType.INTERNAL;
    private static final BiPredicate<Object, @NotNull AutomationType> notExternal = (t, automationType) -> automationType != AutomationType.EXTERNAL;

    private ConstantPredicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return alwaysTrue;
    }

    public static <T, U> BiPredicate<T, U> alwaysTrueBi() {
        return alwaysTrueBi;
    }

    public static <T, U, V> TriPredicate<T, U, V> alwaysTrueTri() {
        return alwaysTrueTri;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return alwaysFalse;
    }

    public static <T, V> BiPredicate<T, V> alwaysFalseBi() {
        return alwaysFalseBi;
    }

    public static <T, U, V> TriPredicate<T, U, V> alwaysFalseTri() {
        return alwaysFalseTri;
    }

    public static <T> BiPredicate<T, @NotNull AutomationType> internalOnly() {
        return internalOnly;
    }

    public static <T> BiPredicate<T, @NotNull AutomationType> notExternal() {
        return notExternal;
    }
}

