/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiTankBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.network.to_server.PacketDropperUse;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiChemicalBar<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends GuiTankBar<STACK> {
    public GuiChemicalBar(IGuiWrapper gui, GuiTankBar.TankInfoProvider<STACK> infoProvider, int x, int y, int width, int height, boolean horizontal) {
        super(gui, infoProvider, x, y, width, height, horizontal);
    }

    @Override
    protected boolean isEmpty(STACK stack) {
        return ((ChemicalStack)stack).isEmpty();
    }

    @Override
    @Nullable
    protected PacketDropperUse.TankType getType(STACK stack) {
        Object type = ((ChemicalStack)((GuiTankBar.TankInfoProvider)this.getHandler()).getStack()).getType();
        if (type instanceof Gas) {
            return PacketDropperUse.TankType.GAS_TANK;
        }
        if (type instanceof InfuseType) {
            return PacketDropperUse.TankType.INFUSION_TANK;
        }
        if (type instanceof Pigment) {
            return PacketDropperUse.TankType.PIGMENT_TANK;
        }
        if (type instanceof Slurry) {
            return PacketDropperUse.TankType.SLURRY_TANK;
        }
        return null;
    }

    @Override
    protected List<Component> getTooltip(STACK stack) {
        List<Component> tooltips = super.getTooltip(stack);
        ChemicalUtil.addChemicalDataToTooltip(tooltips, ((ChemicalStack)stack).getType(), Minecraft.m_91087_().f_91066_.f_92125_);
        return tooltips;
    }

    @Override
    protected void applyRenderColor(GuiGraphics guiGraphics, STACK stack) {
        MekanismRenderer.color(guiGraphics, stack);
    }

    @Override
    protected TextureAtlasSprite getIcon(STACK stack) {
        return MekanismRenderer.getChemicalTexture(((ChemicalStack)stack).getType());
    }

    public static <STACK extends ChemicalStack<?>, TANK extends IChemicalTank<?, STACK>> GuiTankBar.TankInfoProvider<STACK> getProvider(final TANK tank, final List<TANK> tanks) {
        return new GuiTankBar.TankInfoProvider<STACK>(){

            @Override
            @NotNull
            public STACK getStack() {
                return tank.getStack();
            }

            @Override
            public int getTankIndex() {
                return tanks.indexOf(tank);
            }

            @Override
            public Component getTooltip() {
                if (tank.isEmpty()) {
                    return MekanismLang.EMPTY.translate(new Object[0]);
                }
                if (tank.getStored() == Long.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(tank.getType(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(tank.getType(), TextUtils.format(tank.getStored()));
            }

            @Override
            public double getLevel() {
                return (double)tank.getStored() / (double)tank.getCapacity();
            }
        };
    }
}

