/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.BooleanPropertyData;

public abstract class SyncableBoolean
implements ISyncableData {
    private boolean lastKnownValue;

    public abstract boolean get();

    public abstract void set(boolean var1);

    @Override
    public ISyncableData.DirtyType isDirty() {
        boolean oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public BooleanPropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new BooleanPropertyData(property, this.get());
    }

    public static SyncableBoolean create(final boolean[] booleanArray, final int idx) {
        return new SyncableBoolean(){

            @Override
            public boolean get() {
                return booleanArray[idx];
            }

            @Override
            public void set(boolean value) {
                booleanArray[idx] = value;
            }
        };
    }

    public static SyncableBoolean create(final boolean[][] booleanArray, final int idx1, final int idx2) {
        return new SyncableBoolean(){

            @Override
            public boolean get() {
                return booleanArray[idx1][idx2];
            }

            @Override
            public void set(boolean value) {
                booleanArray[idx1][idx2] = value;
            }
        };
    }

    public static SyncableBoolean create(final BooleanSupplier getter, final BooleanConsumer setter) {
        return new SyncableBoolean(){

            @Override
            public boolean get() {
                return getter.getAsBoolean();
            }

            @Override
            public void set(boolean value) {
                setter.accept(value);
            }
        };
    }
}

