/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.config;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.shadow.blue.endless.jankson.Jankson;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonGrammar;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonObject;
import corgitaco.corgilib.shadow.blue.endless.jankson.api.SyntaxError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ConfigUtils {
    public static <T> T loadConfig(Path path, Codec<T> codec, T defaultConfig) {
        if (!path.toFile().exists()) {
            ConfigUtils.createDefaultFile(path, codec, defaultConfig);
            return defaultConfig;
        }
        Jankson build = new Jankson.Builder().build();
        try {
            String configFile = Files.readString(path).strip();
            JsonObject load = build.load(configFile);
            Pair configResult = (Pair)codec.decode((DynamicOps)JanksonJsonOps.INSTANCE, (Object)load).result().orElseThrow();
            Object config = configResult.getFirst();
            ConfigUtils.createDefaultFile(path, codec, config);
            return (T)config;
        }
        catch (SyntaxError | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void createDefaultFile(Path path, Codec<T> codec, T config) {
        JsonElement jsonElement = (JsonElement)codec.encodeStart((DynamicOps)JanksonJsonOps.INSTANCE, config).result().orElseThrow();
        String json = jsonElement.toJson(JsonGrammar.JSON5);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public record CommentValue<T>(String comment, T value) {
        public static <T> CommentValue<T> of(String comment, T value) {
            return new CommentValue<T>(comment, value);
        }
    }
}

