/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.sand;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

public class BWGSandSet {
    private static final ArrayList<BWGSandSet> sandSets = new ArrayList();
    private final String name;
    private final Supplier<SandBlock> sand;
    private final Supplier<Block> sandstone;
    private final Supplier<StairBlock> sandstoneStairs;
    private final Supplier<SlabBlock> sandstoneSlab;
    private final Supplier<WallBlock> sandstoneWall;
    private final Supplier<Block> chiseledSandstone;
    private final Supplier<Block> smoothSandstone;
    private final Supplier<StairBlock> smoothSandstoneStairs;
    private final Supplier<SlabBlock> smoothSandstoneSlab;
    private final Supplier<Block> cutSandstone;
    private final Supplier<SlabBlock> cutSandstoneSlab;
    private final TagKey<Block> sandstoneBlocksTag;
    private final TagKey<Item> sandstoneBlocksItemTag;
    private final TagKey<Block> sandBlockTag;
    private final TagKey<Item> sandItemTag;
    private final TagKey<Block> sandstoneSlabsTag;
    private final TagKey<Item> sandstoneSlabsItemTag;
    private final TagKey<Block> sandstoneStairsTag;
    private final TagKey<Item> sandstoneStairsItemTag;

    public BWGSandSet(String name, int dustColor) {
        this.name = name;
        this.sand = BWGBlocks.registerCubeAllBlockItem(name + "_sand", () -> new SandBlock(dustColor, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
        this.sandstone = BWGBlocks.registerBlockItem(name + "_sandstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
        this.sandstoneStairs = BWGBlocks.registerBlockItem(name + "_sandstone_stairs", () -> new StairBlock(this.sandstone.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50263_)));
        this.sandstoneSlab = BWGBlocks.registerBlockItem(name + "_sandstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50406_)));
        this.sandstoneWall = BWGBlocks.registerBlockItem(name + "_sandstone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50613_)));
        this.chiseledSandstone = BWGBlocks.registerBlockItem("chiseled_" + name + "_sandstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50063_)));
        this.smoothSandstone = BWGBlocks.registerBlockItem("smooth_" + name + "_sandstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50471_)));
        this.smoothSandstoneStairs = BWGBlocks.registerBlockItem("smooth_" + name + "_sandstone_stairs", () -> new StairBlock(this.smoothSandstone.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50636_)));
        this.smoothSandstoneSlab = BWGBlocks.registerBlockItem("smooth_" + name + "_sandstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50649_)));
        this.cutSandstone = BWGBlocks.registerBlockItem("cut_" + name + "_sandstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_)));
        this.cutSandstoneSlab = BWGBlocks.registerBlockItem("cut_" + name + "_sandstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50407_)));
        this.sandstoneBlocksTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_blocks"));
        this.sandstoneBlocksItemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_blocks"));
        this.sandBlockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)BiomesWeveGone.id("sand/" + name));
        this.sandItemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomesWeveGone.id("sand/" + name));
        this.sandstoneSlabsTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_slabs"));
        this.sandstoneSlabsItemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_slabs"));
        this.sandstoneStairsTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_stairs"));
        this.sandstoneStairsItemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_stairs"));
        sandSets.add(this);
    }

    public String getName() {
        return this.name;
    }

    public SandBlock getSand() {
        return this.sand.get();
    }

    public Block getSandstone() {
        return this.sandstone.get();
    }

    public StairBlock getSandstoneStairs() {
        return this.sandstoneStairs.get();
    }

    public SlabBlock getSandstoneSlab() {
        return this.sandstoneSlab.get();
    }

    public WallBlock getSandstoneWall() {
        return this.sandstoneWall.get();
    }

    public Block getChiseledSandstone() {
        return this.chiseledSandstone.get();
    }

    public Block getSmoothSandstone() {
        return this.smoothSandstone.get();
    }

    public StairBlock getSmoothSandstoneStairs() {
        return this.smoothSandstoneStairs.get();
    }

    public SlabBlock getSmoothSandstoneSlab() {
        return this.smoothSandstoneSlab.get();
    }

    public Block getCutSandstone() {
        return this.cutSandstone.get();
    }

    public SlabBlock getCutSandstoneSlab() {
        return this.cutSandstoneSlab.get();
    }

    public TagKey<Block> getSandstoneBlocksTag() {
        return this.sandstoneBlocksTag;
    }

    public TagKey<Item> getSandstoneBlocksItemTag() {
        return this.sandstoneBlocksItemTag;
    }

    public TagKey<Block> getSandBlockTag() {
        return this.sandBlockTag;
    }

    public TagKey<Item> getSandItemTag() {
        return this.sandItemTag;
    }

    public TagKey<Block> getSandstoneSlabsTag() {
        return this.sandstoneSlabsTag;
    }

    public TagKey<Item> getSandstoneSlabsItemTag() {
        return this.sandstoneSlabsItemTag;
    }

    public TagKey<Block> getSandstoneStairsTag() {
        return this.sandstoneStairsTag;
    }

    public TagKey<Item> getSandstoneStairsItemTag() {
        return this.sandstoneStairsItemTag;
    }

    public BlockFamily getSandStoneFamily() {
        return BlockFamilies.m_175935_((Block)this.getSandstone()).m_175996_((Block)this.getSandstoneWall()).m_175988_((Block)this.getSandstoneStairs()).m_175986_((Block)this.getSandstoneSlab()).m_175971_(this.getChiseledSandstone()).m_175978_(this.getCutSandstone()).m_175975_().m_175962_();
    }

    public BlockFamily getSmoothSandStoneFamily() {
        return BlockFamilies.m_175935_((Block)this.getSmoothSandstone()).m_175988_((Block)this.getSmoothSandstoneStairs()).m_175986_((Block)this.getSmoothSandstoneSlab()).m_175962_();
    }

    public BlockFamily getCutSandStoneFamily() {
        return BlockFamilies.m_175935_((Block)this.getCutSandstone()).m_175986_((Block)this.getCutSandstoneSlab()).m_175962_();
    }

    public static ArrayList<BWGSandSet> getSandSets() {
        return sandSets;
    }
}

