/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class VineProcessorFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public VineProcessorFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        ChunkAccess chunk = context.m_159774_().m_46865_(context.m_159777_());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ChunkPos pos = chunk.m_7697_();
        int minWorldX = pos.m_45604_();
        int minWorldZ = pos.m_45605_();
        WorldGenLevel level = context.m_159774_();
        for (int sectionIdx = 0; sectionIdx < chunk.m_280525_(); ++sectionIdx) {
            int sectionY = chunk.m_151568_(sectionIdx);
            int startY = SectionPos.m_123223_((int)sectionY);
            LevelChunkSection section = chunk.m_183278_(sectionIdx);
            if (section.m_188008_()) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
                    int heightSection = SectionPos.m_123171_((int)height);
                    if (sectionY < heightSection) continue;
                    for (int y = 0; y < 16; ++y) {
                        int worldY = y + startY;
                        if (worldY <= height) continue;
                        mutableBlockPos.m_122178_(minWorldX + x, worldY, minWorldZ + z);
                        BlockState blockState = chunk.m_8055_((BlockPos)mutableBlockPos);
                        if (!blockState.m_60795_() || !(context.m_225041_().m_188500_() < 0.05)) continue;
                        int length = -1;
                        for (Direction direction : DIRECTIONS) {
                            mutableBlockPos.m_122178_(minWorldX + x, worldY, minWorldZ + z).m_122173_(direction);
                            if (!level.m_8055_((BlockPos)mutableBlockPos).m_60815_()) continue;
                            if (length == -1) {
                                length = context.m_225041_().m_216339_(3, 10);
                            }
                            BlockState state = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)direction), (Comparable)Boolean.valueOf(true));
                            chunk.m_6978_((BlockPos)mutableBlockPos.m_122178_(minWorldX + x, worldY, minWorldZ + z), state, false);
                            for (int vineLength = 0; vineLength < length && chunk.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN)).m_60795_(); ++vineLength) {
                                chunk.m_6978_((BlockPos)mutableBlockPos, state, false);
                            }
                        }
                    }
                }
            }
        }
        return true;
    }
}

