/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakeConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakePiece;
import org.jetbrains.annotations.NotNull;

public class LargeLakeStructure
extends Structure {
    public static final Codec<LargeLakeStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)LargeLakeStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)LargeLakeConfig.CODEC.fieldOf("config").forGetter(largeLakeStructure -> largeLakeStructure.largeLakeConfig)).apply((Applicative)builder, LargeLakeStructure::new)).codec();
    private final LargeLakeConfig largeLakeConfig;

    public LargeLakeStructure(Structure.StructureSettings settings, LargeLakeConfig largeLakeConfig) {
        super(settings);
        this.largeLakeConfig = largeLakeConfig;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        LevelHeightAccessor levelHeightAccessor;
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        int blockX = chunkPos.m_151382_(random.m_188503_(16));
        int blockZ = chunkPos.m_151391_(random.m_188503_(16));
        int lakeRadius = random.m_216332_(96, 128);
        RandomState randomState = context.f_226624_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        int baseHeight = chunkGenerator.m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, levelHeightAccessor = context.f_226629_(), randomState);
        if (baseHeight <= chunkGenerator.m_6337_() || baseHeight < chunkGenerator.m_214096_(blockX, blockZ, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        return LargeLakeStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, piecesBuilder -> {
            BlockPos lakeOrigin = new BlockPos(blockX, baseHeight, blockZ);
            this.createLakePieces(context, (StructurePiecesBuilder)piecesBuilder, lakeRadius, lakeOrigin, this.largeLakeConfig.depth().m_214085_((RandomSource)random), levelHeightAccessor);
        });
    }

    private void createLakePieces(Structure.GenerationContext context, StructurePiecesBuilder piecesBuilder, int arenaFloorRadius, BlockPos arenaOrigin, int lakeDepth, LevelHeightAccessor levelHeightAccessor) {
        for (int chunkX = -(SectionPos.m_123171_((int)arenaFloorRadius) + 1); chunkX <= SectionPos.m_123171_((int)arenaFloorRadius) + 1; ++chunkX) {
            for (int chunkZ = -(SectionPos.m_123171_((int)arenaFloorRadius) + 1); chunkZ <= SectionPos.m_123171_((int)arenaFloorRadius) + 1; ++chunkZ) {
                BlockPos chunkWorldPos = new BlockPos(SectionPos.m_123223_((int)(context.f_226628_().f_45578_ + chunkX)), arenaOrigin.m_123342_(), SectionPos.m_123223_((int)(context.f_226628_().f_45579_ + chunkZ)));
                BoundingBox boundingBox = new BoundingBox(chunkWorldPos.m_123341_(), levelHeightAccessor.m_141937_(), chunkWorldPos.m_123343_(), chunkWorldPos.m_123341_() + 15, levelHeightAccessor.m_151558_(), chunkWorldPos.m_123343_() + 15);
                piecesBuilder.m_142679_((StructurePiece)new LargeLakePiece(arenaOrigin, arenaFloorRadius, 20, boundingBox, this.largeLakeConfig.features()));
            }
        }
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return BWGStructureTypes.LARGE_LAKE.get();
    }
}

