/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.block.be.FeedingTroughBlockEntity;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class FeedingTroughBlock
extends ZetaBlock
implements EntityBlock {
    private static final SoundType WOOD_WITH_PLANT_STEP = new ForgeSoundType(1.0f, 1.0f, () -> SoundEvents.f_12630_, () -> SoundEvents.f_11992_, () -> SoundEvents.f_12635_, () -> SoundEvents.f_12634_, () -> SoundEvents.f_12633_);
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    public static final VoxelShape CUBOID_SHAPE = FeedingTroughBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EMPTY_SHAPE = Shapes.m_83113_((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape FULL_SHAPE = Shapes.m_83113_((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape ANIMAL_SHAPE = FeedingTroughBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);

    public FeedingTroughBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_256791_, (ItemLike)Blocks.f_50715_, true);
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Entity entity;
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ecc = (EntityCollisionContext)context;
            v0 = ecc.m_193113_();
        } else {
            v0 = entity = null;
        }
        if (entity instanceof Animal) {
            return ANIMAL_SHAPE;
        }
        return EMPTY_SHAPE;
    }

    @NotNull
    public VoxelShape m_6079_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return CUBOID_SHAPE;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)FULL) != false ? FULL_SHAPE : EMPTY_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FULL});
    }

    public SoundType m_49962_(BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)FULL)).booleanValue()) {
            return WOOD_WITH_PLANT_STEP;
        }
        return super.m_49962_(pState);
    }

    public void m_142072_(Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float distance) {
        if (((Boolean)level.m_8055_(pos).m_61143_((Property)FULL)).booleanValue()) {
            entity.m_142535_(distance, 0.2f, level.m_269111_().m_268989_());
        } else {
            super.m_142072_(level, state, pos, entity, distance);
        }
    }

    public void m_6810_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof FeedingTroughBlockEntity) {
                FeedingTroughBlockEntity f = (FeedingTroughBlockEntity)tile;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)f);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider container = this.m_7246_(state, world, pos);
        if (container != null) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)container);
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_8133_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        MenuProvider m;
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof MenuProvider ? (m = (MenuProvider)tile) : null;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FeedingTroughBlockEntity(pos, state);
    }
}

