/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.tweaks.module.PatTheDogsModule;

public class WantLoveGoal
extends Goal {
    private static final String PET_TIME = "quark:PetTime";
    private final TamableAnimal creature;
    private LivingEntity leapTarget;
    public final float leapUpMotion;

    public static void setPetTime(TamableAnimal entity) {
        entity.getPersistentData().m_128356_(PET_TIME, entity.m_9236_().m_46467_());
    }

    public static boolean canPet(TamableAnimal entity) {
        return WantLoveGoal.timeSinceLastPet(entity) > 20L;
    }

    public static boolean needsPets(TamableAnimal entity) {
        if (PatTheDogsModule.dogsWantLove <= 0) {
            return false;
        }
        return WantLoveGoal.timeSinceLastPet(entity) > (long)PatTheDogsModule.dogsWantLove;
    }

    public static long timeSinceLastPet(TamableAnimal entity) {
        if (!entity.m_21824_()) {
            return 0L;
        }
        long lastPetAt = entity.getPersistentData().m_128454_(PET_TIME);
        return entity.m_9236_().m_46467_() - lastPetAt;
    }

    public WantLoveGoal(TamableAnimal creature, float leapMotion) {
        this.creature = creature;
        this.leapUpMotion = leapMotion;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        this.leapTarget = this.creature.m_269323_();
        if (this.leapTarget == null) {
            return false;
        }
        double distanceToTarget = this.creature.m_20280_((Entity)this.leapTarget);
        return 4.0 <= distanceToTarget && distanceToTarget <= 16.0 && this.creature.m_20096_() && this.creature.m_217043_().m_188503_(5) == 0;
    }

    public boolean m_8045_() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        return !this.creature.m_20096_();
    }

    public void m_8056_() {
        Vec3 leapPos = this.leapTarget.m_20182_();
        Vec3 creaturePos = this.creature.m_20182_();
        double dX = leapPos.f_82479_ - creaturePos.f_82479_;
        double dZ = leapPos.f_82481_ - creaturePos.f_82481_;
        float leapMagnitude = (float)Math.sqrt(dX * dX + dZ * dZ);
        Vec3 motion = this.creature.m_20184_();
        if ((double)leapMagnitude >= 1.0E-4) {
            motion = motion.m_82520_(dX / (double)leapMagnitude * 0.4 + motion.f_82479_ * 0.2, 0.0, dZ / (double)leapMagnitude * 0.4 + motion.f_82481_ * 0.2);
        }
        motion = motion.m_82520_(0.0, (double)this.leapUpMotion, 0.0);
        this.creature.m_20256_(motion);
    }
}

