/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.util;

import org.jetbrains.annotations.NotNull;

public class Pair<K, V> {
    @NotNull
    private final K key;
    @NotNull
    private final V value;

    public Pair(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.key = key;
        this.value = value;
    }

    @NotNull
    public K getKey() {
        return this.key;
    }

    @NotNull
    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Pair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }
}

