/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.KeyBinds;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.handler.HUDRenderHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.event.GunReloadEvent;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageAim;
import top.ribs.scguns.network.message.C2SMessageGunLoaded;
import top.ribs.scguns.network.message.C2SMessageLeftOverAmmo;
import top.ribs.scguns.network.message.C2SMessageReload;
import top.ribs.scguns.network.message.C2SMessageUnload;
import top.ribs.scguns.util.GunModifierHelper;

public class ReloadHandler {
    private static ReloadHandler instance;
    private int startReloadTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;

    public static ReloadHandler get() {
        if (instance == null) {
            instance = new ReloadHandler();
        }
        return instance;
    }

    private ReloadHandler() {
    }

    public static void loaded(Player player) {
        Item item = player.m_21205_().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            ItemStack stack = player.m_21205_();
            CompoundTag tag = stack.m_41784_();
            Gun gun = gunItem.getModifiedGun(stack);
            if (gun.getReloads().getReloadType() == ReloadType.MANUAL) {
                if (tag.m_128471_("scguns:ReloadComplete") && !tag.m_128471_("scguns:IsPlayingReloadStop")) {
                    tag.m_128379_("scguns:IsPlayingReloadStop", true);
                    tag.m_128473_("InCriticalReloadPhase");
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    if (item instanceof AnimatedGunItem) {
                        AnimatedGunItem animatedGun = (AnimatedGunItem)item;
                        long id = GeoItem.getId((ItemStack)stack);
                        AnimationController animationController = (AnimationController)animatedGun.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                        if (animationController != null) {
                            if (animatedGun.isInCarbineMode(stack)) {
                                animationController.tryTriggerAnimation("carbine_reload_stop");
                            } else {
                                animationController.tryTriggerAnimation("reload_stop");
                            }
                        }
                    }
                }
            } else if (tag.m_128471_("scguns:ReloadComplete")) {
                tag.m_128379_("scguns:IsPlayingReloadStop", true);
                tag.m_128473_("InCriticalReloadPhase");
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                if (item instanceof AnimatedGunItem) {
                    long id = GeoItem.getId((ItemStack)stack);
                    AnimationController animationController = (AnimationController)((AnimatedGunItem)item).getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                    if (animationController != null) {
                        animationController.tryTriggerAnimation("reload_stop");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Gun gun;
            ItemStack stack;
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() && ((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(false));
            }
            this.prevReloadTimer = this.reloadTimer;
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                stack = player.m_21205_();
                if (Minecraft.m_91087_().m_91104_() && stack.m_41720_() instanceof GunItem) {
                    Gun gun2 = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                    CompoundTag tag = stack.m_41784_();
                    if (gun2.getReloads().getReloadType() == ReloadType.MANUAL) {
                        tag.m_128359_("scguns:ReloadState", "STOPPING");
                        tag.m_128379_("scguns:IsPlayingReloadStop", true);
                        tag.m_128473_("InReloadLoop");
                        tag.m_128473_("scguns:IsReloading");
                        Item item = stack.m_41720_();
                        if (item instanceof AnimatedGunItem) {
                            AnimatedGunItem animatedGun = (AnimatedGunItem)item;
                            long id = GeoItem.getId((ItemStack)stack);
                            AnimationController controller = (AnimationController)animatedGun.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                            if (controller != null) {
                                controller.stop();
                                controller.setAnimationSpeed(1.0);
                                controller.tryTriggerAnimation(animatedGun.isInCarbineMode(stack) ? "carbine_reload_stop" : "reload_stop");
                            }
                        }
                    }
                    this.setReloading(false);
                    return;
                }
            }
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageLeftOverAmmo());
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() && this.reloadingSlot != player.m_150109_().f_35977_) {
                this.setReloading(false);
            }
            this.updateReloadTimer((Player)player);
            stack = player.m_21205_();
            if (stack.m_41720_() instanceof GunItem && !(stack.m_41720_() instanceof AnimatedGunItem) && (gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack)).getReloads().getReloadType() == ReloadType.MAG_FED && this.reloadTimer <= 0 && ((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGunLoaded());
                this.setReloading(false);
            }
            HUDRenderHandler.updateReserveAmmo((Player)player);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem) {
            CompoundTag tag = stack.m_41784_();
            ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            tag.m_128471_("InCriticalReloadPhase");
            if (KeyBinds.KEY_RELOAD.m_90857_() && event.getAction() == 1) {
                boolean currentlyReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
                if (currentlyReloading) {
                    return;
                }
                this.setReloading(true);
                HUDRenderHandler.updateReserveAmmo((Player)player);
            }
            if (KeyBinds.KEY_UNLOAD.m_90859_() && event.getAction() == 1) {
                this.setReloading(false);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageUnload());
                HUDRenderHandler.stageReserveAmmoUpdate();
            }
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem) {
            CompoundTag tag = stack.m_41784_();
            Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            boolean inCriticalPhase = tag.m_128471_("InCriticalReloadPhase");
            boolean isReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
            if (!isReloading && inCriticalPhase) {
                tag.m_128473_("InCriticalReloadPhase");
                inCriticalPhase = false;
            }
            if (KeyBinds.getAimMapping().m_90857_() && event.getAction() == 1 && inCriticalPhase && gun.getReloads().getReloadType() != ReloadType.MANUAL) {
                return;
            }
            KeyBinds.getAimMapping().m_90857_();
        }
    }

    public void setReloading(boolean reloading) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        CompoundTag tag = stack.m_41784_();
        boolean inCriticalPhase = tag.m_128471_("InCriticalReloadPhase");
        if (reloading) {
            Item item = stack.m_41720_();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                if (inCriticalPhase) {
                    return;
                }
                if (!tag.m_128425_("IgnoreAmmo", 1)) {
                    if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                        return;
                    }
                    Item item2 = stack.m_41720_();
                    if (item2 instanceof AnimatedGunItem) {
                        boolean hasReloadTags;
                        AnimatedGunItem animatedGun = (AnimatedGunItem)item2;
                        gunItem.getModifiedGun(stack);
                        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(false));
                            AimingHandler.get().aiming = false;
                        }
                        if (!tag.m_128471_("IsDrawn")) {
                            tag.m_128379_("IsDrawn", true);
                            tag.m_128405_("DrawnTick", 15);
                        }
                        boolean bl = hasReloadTags = tag.m_128471_("IsReloading") || tag.m_128471_("scguns:IsReloading") || tag.m_128441_("scguns:ReloadState");
                        if (hasReloadTags && !((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                            animatedGun.cleanupReloadState(tag);
                        }
                        if (tag.m_128471_("IsReloading") && ((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                            return;
                        }
                    }
                    Gun gun2 = gunItem.getModifiedGun(stack);
                    if (tag.m_128451_("AmmoCount") >= GunModifierHelper.getModifiedAmmoCapacity(stack, gun2)) {
                        return;
                    }
                    if (Gun.findAmmo((Player)player, gun2.getProjectile().getItem()).stack().m_41619_()) {
                        return;
                    }
                    ResourceLocation preReloadSound = gun2.getSounds().getPreReload();
                    if (preReloadSound != null) {
                        Config.SERVER.reloadMaxDistance.get();
                        player.m_5496_(Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(preReloadSound)), 0.7f, 1.0f);
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, stack))) {
                        return;
                    }
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(true));
                    this.reloadingSlot = player.m_150109_().f_35977_;
                    Item item3 = stack.m_41720_();
                    if (item3 instanceof AnimatedGunItem) {
                        AnimatedGunItem animatedGun = (AnimatedGunItem)item3;
                        tag.m_128379_("IsReloading", true);
                        tag.m_128379_("scguns:IsReloading", true);
                        tag.m_128473_("ReloadComplete");
                        tag.m_128473_("scguns:ReloadComplete");
                        if (gun2.getReloads().getReloadType() != ReloadType.MANUAL) {
                            tag.m_128379_("InCriticalReloadPhase", true);
                        }
                        long id = GeoItem.getId((ItemStack)stack);
                        AnimationController controller = (AnimationController)animatedGun.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                        if (controller != null) {
                            ReloadType reloadType = gun2.getReloads().getReloadType();
                            if (reloadType == ReloadType.MAG_FED || reloadType == ReloadType.SINGLE_ITEM) {
                                tag.m_128379_("IsMagReload", true);
                                if (animatedGun.isInCarbineMode(stack)) {
                                    controller.tryTriggerAnimation("carbine_reload");
                                } else {
                                    controller.tryTriggerAnimation("reload");
                                }
                            }
                            if (gun2.getReloads().getReloadType() == ReloadType.MANUAL) {
                                tag.m_128379_("IsManualReload", true);
                                tag.m_128359_("scguns:ReloadState", "NONE");
                                if (animatedGun.isInCarbineMode(stack)) {
                                    controller.tryTriggerAnimation("carbine_reload_start");
                                } else {
                                    controller.tryTriggerAnimation("reload_start");
                                }
                            }
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, stack));
                }
            }
        } else {
            Gun gun;
            if (inCriticalPhase && (gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack)).getReloads().getReloadType() != ReloadType.MANUAL) {
                return;
            }
            Object gun2 = stack.m_41720_();
            if (gun2 instanceof AnimatedGunItem) {
                AnimatedGunItem animatedGun = (AnimatedGunItem)gun2;
                gun2 = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                if (((Gun)gun2).getReloads().getReloadType() == ReloadType.MANUAL) {
                    if (tag.m_128471_("scguns:IsReloading") && !tag.m_128471_("scguns:IsPlayingReloadStop")) {
                        tag.m_128359_("scguns:ReloadState", "STOPPING");
                        tag.m_128379_("scguns:IsPlayingReloadStop", true);
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                    } else {
                        animatedGun.cleanupReloadState(tag);
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        tag.m_128473_("InCriticalReloadPhase");
                        tag.m_128473_("IsManualReload");
                        tag.m_128473_("InReloadLoop");
                        tag.m_128473_("PendingStopTransition");
                        tag.m_128473_("PendingStopTime");
                        tag.m_128473_("LastReloadStateChange");
                        tag.m_128473_("ManualReloadInitialized");
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                    }
                } else if (!inCriticalPhase) {
                    animatedGun.cleanupReloadState(tag);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    tag.m_128473_("InCriticalReloadPhase");
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                }
            } else {
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                tag.m_128473_("InCriticalReloadPhase");
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                this.reloadingSlot = -1;
            }
        }
        if (stack.m_41720_() instanceof GunItem) {
            HUDRenderHandler.updateReserveAmmo((Player)player);
        }
    }

    private void updateReloadTimer(Player player) {
        ItemStack stack = player.m_21205_();
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
            if (stack.m_41720_() instanceof AnimatedGunItem) {
                return;
            }
            if (this.startReloadTick == -1) {
                this.startReloadTick = player.f_19797_ + 5;
            }
            if (this.reloadTimer < 5) {
                ++this.reloadTimer;
            }
        } else {
            if (this.startReloadTick != -1) {
                this.startReloadTick = -1;
            }
            if (this.reloadTimer > 0) {
                --this.reloadTimer;
            }
        }
    }

    public int getStartReloadTick() {
        return this.startReloadTick;
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public float getReloadProgress(float partialTicks) {
        return ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
    }
}

