/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class DozierRLModel
implements IOverrideModel {
    private static final float ROTATION_INCREMENT = 90.0f;
    private int shotCount = 0;

    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.DOZIER_RL_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        if (Gun.getScope(stack) == null) {
            RenderUtil.renderModel(SpecialModels.DOZIER_RL_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        } else {
            RenderUtil.renderModel(SpecialModels.DOZIER_RL_NO_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.VERTICAL_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.DOZIER_RL_GRIP_VERTICAL.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.LIGHT_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.DOZIER_RL_GRIP_LIGHT.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.IRON_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.DOZIER_RL_IRON_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.ANTHRALITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.DOZIER_RL_ANTHRALITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.DIAMOND_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.DOZIER_RL_DIAMOND_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.NETHERITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.DOZIER_RL_NETHERITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
        if (entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            this.renderBoltAndMagazine(matrixStack, buffer, stack, light, overlay);
            this.renderFlame(matrixStack, buffer, stack, light, overlay);
        }
    }

    private void renderBoltAndMagazine(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.3625, 0.0);
        if (cooldown > 0.0f) {
            this.shotCount = (this.shotCount + 1) % 4;
        }
        matrixStack.m_85837_(0.0, 0.3625, 0.0);
        matrixStack.m_85849_();
        this.renderMagazineRotation(matrixStack, buffer, stack, light, overlay);
    }

    private void renderMagazineRotation(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.0, 0.0);
        float currentRotation = (float)this.shotCount * 90.0f;
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(currentRotation));
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        RenderUtil.renderModel(SpecialModels.DOZIER_RL_DRUM.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }

    private void renderFlame(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.3625, 0.0);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        cooldown = (float)this.ease(cooldown);
        float scale = cooldown > 0.0f ? 1.0f : 0.0f;
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_252880_(0.0f, 0.0f, cooldown / 8.0f);
        matrixStack.m_85837_(0.0, 0.3625, 0.0);
        RenderUtil.renderModel(SpecialModels.DOZIER_RL_FIRE.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }

    private double ease(double x) {
        return 1.0 - Math.pow(1.0 - 2.0 * x, 4.0);
    }
}

