/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.handler.BeamHandler;
import top.ribs.scguns.common.BeamHandlerCommon;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBeamImpact;
import top.ribs.scguns.network.message.S2CMessageBeamPenetration;
import top.ribs.scguns.network.message.S2CMessageBeamUpdate;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.network.message.S2CMessageStopBeam;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;
import top.ribs.scguns.util.math.ExtendedEntityRayTraceResult;

public class BeamWeaponHandler {
    private static final Map<UUID, BeamHandler.BeamInfo> activeBeams = new HashMap<UUID, BeamHandler.BeamInfo>();

    public static void handleBeamWeapon(ServerPlayer player, ItemStack heldItem, Gun modifiedGun) {
        FireMode fireMode;
        UUID playerId = player.m_20148_();
        Level world = player.m_9236_();
        Vec3 beamOriginOffset = new Vec3(0.0, (double)player.m_20192_(), 0.0);
        Vec3 beamOrigin = player.m_20182_().m_82549_(beamOriginOffset);
        Vec3 lookVec = player.m_20154_();
        double maxDistance = modifiedGun.getGeneral().getBeamMaxDistance();
        Vec3 endVec = beamOrigin.m_82549_(lookVec.m_82490_(maxDistance));
        HitResult finalHitResult = BeamHandlerCommon.BeamMiningManager.getBeamHitResult(world, beamOrigin, endVec, (Entity)player, maxDistance);
        Vec3 hitPos = finalHitResult.m_82450_();
        List<Object> glassPenetrations = new ArrayList();
        double damageMultiplier = 1.0;
        if (finalHitResult instanceof BeamHandlerCommon.BeamMiningManager.ExtendedBlockHitResult) {
            BeamHandlerCommon.BeamMiningManager.ExtendedBlockHitResult extendedBlock = (BeamHandlerCommon.BeamMiningManager.ExtendedBlockHitResult)finalHitResult;
            glassPenetrations = extendedBlock.getGlassPenetrations();
            damageMultiplier = extendedBlock.getDamageMultiplier();
        } else if (finalHitResult instanceof BeamHandlerCommon.BeamMiningManager.ExtendedEntityHitResult) {
            BeamHandlerCommon.BeamMiningManager.ExtendedEntityHitResult extendedEntity = (BeamHandlerCommon.BeamMiningManager.ExtendedEntityHitResult)finalHitResult;
            damageMultiplier = extendedEntity.getDamageMultiplier();
        }
        long currentTime = System.currentTimeMillis();
        boolean isBeamFireMode = modifiedGun.getGeneral().getFireMode() == FireMode.BEAM;
        BeamHandler.BeamInfo beamInfo = activeBeams.computeIfAbsent(playerId, k -> new BeamHandler.BeamInfo(beamOrigin, hitPos, currentTime, isBeamFireMode));
        beamInfo.startPos = beamOrigin;
        beamInfo.endPos = hitPos;
        BeamWeaponHandler.sendBeamUpdate(player, beamOrigin, hitPos);
        if (!glassPenetrations.isEmpty()) {
            BeamWeaponHandler.sendBeamPenetrationEffects(player, playerId, glassPenetrations, beamOrigin);
        }
        BeamWeaponHandler.handleBeamMining(world, finalHitResult, glassPenetrations, player, modifiedGun);
        int damageDelayMs = modifiedGun.getGeneral().getBeamDamageDelay();
        if (currentTime - beamInfo.lastDamageTime >= (long)damageDelayMs) {
            BeamWeaponHandler.handleBeamDamage(player, finalHitResult, modifiedGun, damageMultiplier);
            beamInfo.lastDamageTime = currentTime;
        }
        if ((fireMode = modifiedGun.getGeneral().getFireMode()) == FireMode.BEAM || fireMode == FireMode.SEMI_BEAM) {
            if (fireMode == FireMode.BEAM) {
                if (currentTime - beamInfo.startTime >= (long)modifiedGun.getGeneral().getBeamAmmoConsumptionDelay()) {
                    BeamWeaponHandler.consumeBeamAmmo(player, heldItem);
                    beamInfo.startTime = currentTime;
                }
            } else if (beamInfo.startTime == currentTime) {
                BeamWeaponHandler.consumeBeamAmmo(player, heldItem);
            }
        }
    }

    private static void sendBeamUpdate(ServerPlayer player, Vec3 beamOrigin, Vec3 hitPos) {
        double radius = 64.0;
        S2CMessageBeamUpdate beamUpdate = new S2CMessageBeamUpdate(player.m_20148_(), beamOrigin, hitPos);
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)beamOrigin.f_82479_, (double)beamOrigin.f_82480_, (double)beamOrigin.f_82481_, (double)radius), (IMessage)beamUpdate);
    }

    private static void sendBeamPenetrationEffects(ServerPlayer player, UUID playerId, List<BlockHitResult> glassPenetrations, Vec3 beamOrigin) {
        double radius = 64.0;
        S2CMessageBeamPenetration penetrationMessage = new S2CMessageBeamPenetration(playerId, glassPenetrations);
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)beamOrigin.f_82479_, (double)beamOrigin.f_82480_, (double)beamOrigin.f_82481_, (double)radius), (IMessage)penetrationMessage);
    }

    private static void handleBeamMining(Level world, HitResult finalHitResult, List<BlockHitResult> glassPenetrations, ServerPlayer player, Gun modifiedGun) {
        if (finalHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHit = (BlockHitResult)finalHitResult;
            BlockPos pos = blockHit.m_82425_();
            if (!glassPenetrations.contains(blockHit)) {
                BeamHandlerCommon.BeamMiningManager.updateBlockMining(world, pos, player, modifiedGun);
            }
        }
    }

    private static void handleBeamDamage(ServerPlayer player, HitResult hitResult, Gun modifiedGun, double damageMultiplier) {
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            BeamWeaponHandler.handleEntityDamage(player, (EntityHitResult)hitResult, modifiedGun, damageMultiplier);
        } else if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BeamWeaponHandler.sendBeamImpactEffect(player, hitResult.m_82450_());
        }
    }

    private static void handleEntityDamage(ServerPlayer player, EntityHitResult entityHitResult, Gun modifiedGun, double damageMultiplier) {
        Player hitPlayer;
        Entity hitEntity = entityHitResult.m_82443_();
        if (!hitEntity.m_6097_()) {
            return;
        }
        if (hitEntity instanceof Player && !player.m_7099_(hitPlayer = (Player)hitEntity)) {
            return;
        }
        ItemStack weapon = player.m_21205_();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            BeamWeaponHandler.applyBeamImpactEffects(livingEntity, modifiedGun, player);
        }
        float damage = BeamWeaponHandler.calculateBeamDamage(weapon, modifiedGun, player, damageMultiplier, entityHitResult);
        DamageSource damageSource = ModDamageTypes.Sources.projectile((RegistryAccess)player.f_8924_.m_206579_(), null, (LivingEntity)player);
        boolean damaged = hitEntity.m_6469_(damageSource, damage);
        if (damaged) {
            hitEntity.f_19802_ = 0;
            BeamWeaponHandler.applyPostDamageEffects(player, weapon, hitEntity);
            boolean critical = BeamWeaponHandler.isBeamCritical(weapon, modifiedGun, player.m_9236_().f_46441_, modifiedGun.getProjectile().getDamage());
            if (critical) {
                PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageProjectileHitEntity(entityHitResult.m_82450_().f_82479_, entityHitResult.m_82450_().f_82480_, entityHitResult.m_82450_().f_82481_, 2, hitEntity instanceof Player));
            }
        }
        BeamWeaponHandler.sendBeamImpactEffect(player, entityHitResult.m_82450_());
    }

    private static void applyBeamImpactEffects(LivingEntity livingEntity, Gun modifiedGun, ServerPlayer player) {
        Gun.Projectile projectile = modifiedGun.getProjectile();
        ResourceLocation effectLocation = projectile.getImpactEffect();
        if (effectLocation != null) {
            MobEffect effect;
            float effectChance = projectile.getImpactEffectChance();
            if (player.m_9236_().f_46441_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                livingEntity.m_7292_(new MobEffectInstance(effect, projectile.getImpactEffectDuration(), projectile.getImpactEffectAmplifier()));
            }
        }
    }

    private static float calculateBeamDamage(ItemStack weapon, Gun modifiedGun, ServerPlayer player, double damageMultiplier, EntityHitResult hitResult) {
        Entity hitEntity;
        ExtendedEntityRayTraceResult extendedResult;
        float damage = modifiedGun.getProjectile().getDamage();
        damage = GunModifierHelper.getModifiedDamage(weapon, modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(weapon, damage);
        damage = GunEnchantmentHelper.getHeavyShotDamage(weapon, damage);
        damage = GunEnchantmentHelper.getHotBarrelDamage((Player)player, weapon, damage);
        damage = BeamWeaponHandler.getBeamCriticalDamage(weapon, modifiedGun, player.m_9236_().f_46441_, damage);
        damage *= (float)damageMultiplier;
        damage *= ((Double)Config.COMMON.gameplay.globalDamageMultiplier.get()).floatValue();
        if (hitResult instanceof ExtendedEntityRayTraceResult && (extendedResult = (ExtendedEntityRayTraceResult)hitResult).isHeadshot()) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if ((hitEntity = hitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)livingEntity.m_6336_());
            damage = GunEnchantmentHelper.getPuncturingDamageReduction(weapon, livingEntity, damage);
            damage = BeamWeaponHandler.applyProjectileProtection(livingEntity, damage);
            damage = BeamWeaponHandler.calculateBeamArmorBypassDamage(weapon, modifiedGun, livingEntity, damage);
        }
        return damage;
    }

    private static void applyPostDamageEffects(ServerPlayer player, ItemStack weapon, Entity hitEntity) {
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            GunEnchantmentHelper.applyElementalPopEffect(weapon, livingEntity);
            EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)player);
            EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)livingEntity);
            if (player.m_9236_().f_46441_.m_188501_() < 0.05f) {
                hitEntity.m_20254_(3);
            }
            if (GunEnchantmentHelper.shouldSetOnFire((Player)player, weapon)) {
                hitEntity.m_20254_(5);
            }
        }
    }

    private static void sendBeamImpactEffect(ServerPlayer player, Vec3 location) {
        PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageBeamImpact(location, player.m_20148_()));
    }

    private static float getBeamCriticalDamage(ItemStack weapon, Gun modifiedGun, RandomSource rand, float damage) {
        float chance = modifiedGun.getProjectile().getCriticalChance();
        if (rand.m_188501_() < chance) {
            float critMultiplier = modifiedGun.getProjectile().getCritDamageMultiplier();
            return damage * critMultiplier;
        }
        return damage;
    }

    private static boolean isBeamCritical(ItemStack weapon, Gun modifiedGun, RandomSource rand, float baseDamage) {
        float chance = modifiedGun.getProjectile().getCriticalChance();
        return rand.m_188501_() < chance;
    }

    private static float calculateBeamArmorBypassDamage(ItemStack weapon, Gun modifiedGun, LivingEntity target, float damage) {
        float puncturingBypass;
        int armorValue = target.m_21230_();
        float baseReduction = Math.min(0.75f, (float)armorValue * 0.004f);
        float baseArmorBypass = modifiedGun.getProjectile().getArmorPen();
        float totalArmorBypass = baseArmorBypass + (puncturingBypass = GunEnchantmentHelper.getPuncturingArmorBypass(weapon));
        if (totalArmorBypass <= 0.0f) {
            return damage * (1.0f - baseReduction);
        }
        float bypassPercent = totalArmorBypass / 10.0f;
        float effectiveArmor = (float)armorValue * (1.0f - bypassPercent);
        float finalReduction = Math.min(0.75f, effectiveArmor * 0.004f);
        return damage * (1.0f - finalReduction);
    }

    private static float applyProjectileProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44969_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.1f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    private static void consumeBeamAmmo(ServerPlayer player, ItemStack heldItem) {
        int currentAmmo;
        CompoundTag tag;
        if (!player.m_7500_() && !(tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") && (currentAmmo = tag.m_128451_("AmmoCount")) > 0) {
            tag.m_128405_("AmmoCount", currentAmmo - 1);
        }
    }

    public static void stopBeam(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        activeBeams.remove(playerId);
        double radius = 64.0;
        S2CMessageStopBeam stopBeamMessage = new S2CMessageStopBeam(playerId);
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)radius), (IMessage)stopBeamMessage);
    }
}

