/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.RabbitModuleItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitRabbitHandler {
    private static final int REFRESH_INTERVAL = 100;
    private static final double MOVEMENT_THRESHOLD = 0.01;
    private static final Map<UUID, Vec3> previousPositions = new HashMap<UUID, Vec3>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        ExoSuitRabbitHandler.handleRabbitModuleEnergy(player);
    }

    private static void handleRabbitModuleEnergy(Player player) {
        RabbitModuleItem rabbitModule;
        Item item;
        if (!ExoSuitPowerManager.isPowerEnabled(player, "mobility")) {
            return;
        }
        if (!ExoSuitRabbitHandler.hasRabbitModule(player)) {
            return;
        }
        if (!ExoSuitRabbitHandler.isPlayerMoving(player)) {
            return;
        }
        if (!ExoSuitPowerManager.canConsumeEnergy(player, "mobility", 100)) {
            return;
        }
        if (!ExoSuitPowerManager.canUpgradeFunction(player, "mobility")) {
            return;
        }
        ItemStack rabbitUpgrade = ExoSuitRabbitHandler.findRabbitModule(player);
        if (!rabbitUpgrade.m_41619_() && (item = rabbitUpgrade.m_41720_()) instanceof RabbitModuleItem && !(rabbitModule = (RabbitModuleItem)item).canFunctionWithoutPower()) {
            ExoSuitPowerManager.consumeEnergyForUpgrade(player, "mobility", rabbitUpgrade);
        }
    }

    private static boolean isPlayerMoving(Player player) {
        UUID playerId = player.m_20148_();
        Vec3 currentPos = player.m_20182_();
        Vec3 previousPos = previousPositions.get(playerId);
        previousPositions.put(playerId, currentPos);
        if (previousPos == null) {
            return false;
        }
        double distanceMoved = currentPos.m_82554_(previousPos);
        boolean positionChanged = distanceMoved > 0.01;
        boolean hasVelocity = player.m_20184_().m_82556_() > 1.0E-4;
        boolean isWalking = player.m_20142_() || player.m_6069_() || player.m_6047_() || player.f_20902_ != 0.0f || player.f_20900_ != 0.0f;
        return positionChanged || hasVelocity || isWalking;
    }

    private static boolean hasRabbitModule(Player player) {
        return !ExoSuitRabbitHandler.findRabbitModule(player).m_41619_();
    }

    private static ItemStack findRabbitModule(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.BOOTS) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("mobility") || !(upgradeItem.m_41720_() instanceof RabbitModuleItem)) continue;
                return upgradeItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void onPlayerLogout(Player player) {
        previousPositions.remove(player.m_20148_());
    }
}

