/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.entity.client.ModModelLayers;
import top.ribs.scguns.entity.client.ZombifiedHornlinModel;
import top.ribs.scguns.entity.monster.ZombifiedHornlinEntity;

public class ZombifiedHornlinRenderer
extends HumanoidMobRenderer<ZombifiedHornlinEntity, ZombifiedHornlinModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("scguns", "textures/entity/zombified_hornlin.png");

    public ZombifiedHornlinRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new ZombifiedHornlinModel(context.m_174023_(ModModelLayers.ZOMBIFIED_HORNLIN_LAYER)), 0.4f);
        this.m_115326_(new ZombifiedHornlinFoodItemLayer(this, context.m_234598_()));
        this.m_115326_((RenderLayer)new ScaledArmorLayer<ZombifiedHornlinEntity, ZombifiedHornlinModel>(this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
    }

    public ResourceLocation getTextureLocation(ZombifiedHornlinEntity entity) {
        return TEXTURE;
    }

    private static class ZombifiedHornlinFoodItemLayer
    extends RenderLayer<ZombifiedHornlinEntity, ZombifiedHornlinModel> {
        private final ItemInHandRenderer itemInHandRenderer;

        public ZombifiedHornlinFoodItemLayer(HumanoidMobRenderer<ZombifiedHornlinEntity, ZombifiedHornlinModel> renderer, ItemInHandRenderer itemInHandRenderer) {
            super(renderer);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ZombifiedHornlinEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.isEatingGold() && !entity.isPreparingToEat()) {
                return;
            }
            ItemStack heldFood = entity.getHeldFoodItem();
            if (heldFood.m_41619_()) {
                return;
            }
            poseStack.m_85836_();
            ZombifiedHornlinModel model = (ZombifiedHornlinModel)this.m_117386_();
            model.f_102812_.m_104299_(poseStack);
            poseStack.m_85837_(0.125, 0.625, 0.0);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            this.itemInHandRenderer.m_269530_((LivingEntity)entity, heldFood, ItemDisplayContext.GROUND, false, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
    }

    private static class ScaledArmorLayer<T extends ZombifiedHornlinEntity, M extends HumanoidModel<T>>
    extends HumanoidArmorLayer<T, M, HumanoidModel<T>> {
        private final HumanoidModel<T> innerModel;
        private final HumanoidModel<T> outerModel;

        public ScaledArmorLayer(HumanoidMobRenderer<T, M> renderer, HumanoidModel<T> innerModel, HumanoidModel<T> outerModel, ModelManager modelManager) {
            super(renderer, innerModel, outerModel, modelManager);
            this.innerModel = innerModel;
            this.outerModel = outerModel;
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean hasBodyArmor;
            boolean hasHelmet = !entity.m_6844_(EquipmentSlot.HEAD).m_41619_();
            boolean bl = hasBodyArmor = !entity.m_6844_(EquipmentSlot.CHEST).m_41619_() || !entity.m_6844_(EquipmentSlot.LEGS).m_41619_() || !entity.m_6844_(EquipmentSlot.FEET).m_41619_();
            if (!hasHelmet && !hasBodyArmor) {
                return;
            }
            ItemStack helmetItem = entity.m_6844_(EquipmentSlot.HEAD);
            if (hasHelmet) {
                this.innerModel.f_102810_.f_104207_ = false;
                this.innerModel.f_102811_.f_104207_ = false;
                this.innerModel.f_102812_.f_104207_ = false;
                this.innerModel.f_102813_.f_104207_ = false;
                this.innerModel.f_102814_.f_104207_ = false;
                this.outerModel.f_102810_.f_104207_ = false;
                this.outerModel.f_102811_.f_104207_ = false;
                this.outerModel.f_102812_.f_104207_ = false;
                this.outerModel.f_102813_.f_104207_ = false;
                this.outerModel.f_102814_.f_104207_ = false;
                poseStack.m_85836_();
                poseStack.m_85841_(1.21f, 1.0f, 1.05f);
                super.m_6494_(poseStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                poseStack.m_85849_();
                this.innerModel.f_102810_.f_104207_ = true;
                this.innerModel.f_102811_.f_104207_ = true;
                this.innerModel.f_102812_.f_104207_ = true;
                this.innerModel.f_102813_.f_104207_ = true;
                this.innerModel.f_102814_.f_104207_ = true;
                this.outerModel.f_102810_.f_104207_ = true;
                this.outerModel.f_102811_.f_104207_ = true;
                this.outerModel.f_102812_.f_104207_ = true;
                this.outerModel.f_102813_.f_104207_ = true;
                this.outerModel.f_102814_.f_104207_ = true;
            }
            if (hasBodyArmor) {
                entity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                poseStack.m_85836_();
                poseStack.m_85841_(1.2f, 1.05f, 1.35f);
                super.m_6494_(poseStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                poseStack.m_85849_();
                entity.m_8061_(EquipmentSlot.HEAD, helmetItem);
            }
        }
    }
}

