/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.ai.AIType;
import top.ribs.scguns.entity.ai.GunAttackGoal;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.item.GunItem;

public class BlundererEntity
extends Raider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TOSSING_GRENADE = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GRENADE_TOSS_TIMEOUT = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public BlundererEntity(EntityType<? extends Raider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            amount *= 0.15f;
        }
        return super.m_6469_(source, amount);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        EntityEquipmentConfig.equipEntity((Mob)this, "scguns:blunderer");
        this.m_37897_(this.m_6095_() != EntityType.f_20495_ || pReason != MobSpawnType.NATURAL);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(TOSSING_GRENADE, (Object)false);
        this.f_19804_.m_135372_(GRENADE_TOSS_TIMEOUT, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                LivingEntity target;
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() == 6 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + target.m_20205_())) {
                    this.m_7327_((Entity)target);
                }
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
            if (this.isTossingGrenade() && this.getGrenadeTossTimeout() > 0) {
                this.setGrenadeTossTimeout(this.getGrenadeTossTimeout() - 1);
                if (this.getGrenadeTossTimeout() == 6) {
                    this.throwGrenade();
                }
                if (this.getGrenadeTossTimeout() <= 0) {
                    this.setTossingGrenade(false);
                }
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        ItemStack mainHandItem = this.m_21205_();
        boolean hasGun = mainHandItem.m_41720_() instanceof GunItem;
        if (hasGun && this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
        }
    }

    public void m_7895_(int pWave, boolean pUnusedFalse) {
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        super.m_8099_();
        ItemStack mainHandItem = this.m_21205_();
        boolean hasGun = mainHandItem.m_41720_() instanceof GunItem;
        if (hasGun) {
            this.f_21345_.m_25352_(1, new GunAttackGoal<BlundererEntity>(this, mainHandItem, 1.0f, AIType.TACTICAL, 3));
        } else {
            this.f_21345_.m_25352_(1, (Goal)new StampedeChargeGoal(this, 1.0, 16.0, 100));
            this.f_21345_.m_25352_(2, (Goal)new GrenadeTossGoal(this, 12.0, 200));
            this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

                protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                    if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !BlundererEntity.this.isAttacking()) {
                        BlundererEntity.this.setAttacking(true);
                        this.m_25563_();
                        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
            });
        }
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[]{Raider.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    public float m_6100_() {
        return 0.7f;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12310_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        this.m_7327_((Entity)target);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setTossingGrenade(boolean tossing) {
        this.f_19804_.m_135381_(TOSSING_GRENADE, (Object)tossing);
        if (tossing) {
            this.setGrenadeTossTimeout(12);
        }
    }

    public boolean isTossingGrenade() {
        return (Boolean)this.f_19804_.m_135370_(TOSSING_GRENADE);
    }

    public void setGrenadeTossTimeout(int timeout) {
        this.f_19804_.m_135381_(GRENADE_TOSS_TIMEOUT, (Object)timeout);
    }

    public int getGrenadeTossTimeout() {
        return (Integer)this.f_19804_.m_135370_(GRENADE_TOSS_TIMEOUT);
    }

    private void throwGrenade() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 startPos = this.m_20182_().m_82520_(0.0, (double)this.m_20192_() * 0.9, 0.0);
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, 0.5, 0.0);
        double dx = targetPos.f_82479_ - startPos.f_82479_;
        double dy = targetPos.f_82480_ - startPos.f_82480_;
        double dz = targetPos.f_82481_ - startPos.f_82481_;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDistance < 4.0) {
            return;
        }
        double timeToTarget = Math.sqrt(horizontalDistance / 6.0);
        double velocityXZ = horizontalDistance / timeToTarget;
        double velocityY = (dy + 4.905 * timeToTarget * timeToTarget * 0.08) / timeToTarget;
        double motionX = dx / horizontalDistance * velocityXZ * 0.08;
        double motionY = velocityY * 0.08;
        double motionZ = dz / horizontalDistance * velocityXZ * 0.08;
        ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(this.m_9236_(), (LivingEntity)this, 40);
        grenade.m_6034_(startPos.f_82479_ + dx / horizontalDistance * 1.5, startPos.f_82480_, startPos.f_82481_ + dz / horizontalDistance * 1.5);
        grenade.m_20334_(motionX, motionY, motionZ);
        this.m_9236_().m_7967_((Entity)grenade);
        this.m_5496_(SoundEvents.f_12473_, 1.0f, 0.8f);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return this.m_37885_() == null && super.m_6785_(pDistanceToClosestPlayer);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_37885_() != null;
    }

    public static class StampedeChargeGoal
    extends Goal {
        private final BlundererEntity mob;
        private final double speedModifier;
        private final double chargeRange;
        private final int chargeCooldown;
        private int cooldownTicks;
        private int chargeTicks;
        private LivingEntity target;
        private Vec3 chargeDirection;
        private int trampleCounter;

        public StampedeChargeGoal(BlundererEntity mob, double speedModifier, double chargeRange, int chargeCooldown) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.chargeRange = chargeRange;
            this.chargeCooldown = chargeCooldown;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double distanceToTarget = this.mob.m_20280_((Entity)this.target);
            return distanceToTarget <= this.chargeRange * this.chargeRange && distanceToTarget > 9.0;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.chargeTicks > 0;
        }

        public void m_8056_() {
            this.chargeTicks = 4;
            this.trampleCounter = 0;
            this.mob.setCharging(true);
            double dx = this.target.m_20185_() - this.mob.m_20185_();
            double dz = this.target.m_20189_() - this.mob.m_20189_();
            double distance = Math.sqrt(dx * dx + dz * dz);
            this.chargeDirection = distance > 0.1 ? new Vec3(dx / distance, 0.0, dz / distance) : this.mob.m_20154_();
            this.mob.m_5496_(SoundEvents.f_12577_, 1.0f, 0.7f);
        }

        public void m_8037_() {
            if (this.chargeTicks > 0) {
                --this.chargeTicks;
                double speedMultiplier = this.speedModifier * (1.0 + (double)(30 - this.chargeTicks) * 0.02);
                this.mob.m_20334_(this.chargeDirection.f_82479_ * speedMultiplier, this.mob.m_20184_().f_82480_, this.chargeDirection.f_82481_ * speedMultiplier);
                this.mob.m_21563_().m_24946_(this.mob.m_20185_() + this.chargeDirection.f_82479_ * 5.0, this.mob.m_20186_(), this.mob.m_20189_() + this.chargeDirection.f_82481_ * 5.0);
                if (this.chargeTicks % 3 == 0) {
                    this.mob.m_5496_(SoundEvents.f_12361_, 0.5f, 0.9f);
                }
                for (LivingEntity entity : this.mob.m_9236_().m_45976_(LivingEntity.class, this.mob.m_20191_().m_82377_(0.5, 0.2, 0.5))) {
                    if (entity == this.mob || !entity.m_6084_()) continue;
                    this.trampleEntity(entity);
                }
            }
        }

        public void m_8041_() {
            this.mob.setCharging(false);
            this.cooldownTicks = this.chargeCooldown;
            this.target = null;
            this.chargeTicks = 0;
            this.chargeDirection = null;
        }

        private void trampleEntity(LivingEntity entity) {
            float damage = (float)this.mob.m_21133_(Attributes.f_22281_) * 0.8f;
            entity.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage);
            double knockbackX = this.chargeDirection.f_82479_ * 0.6;
            double knockbackZ = this.chargeDirection.f_82481_ * 0.6;
            entity.m_20256_(entity.m_20184_().m_82520_(knockbackX, 0.25, knockbackZ));
            ++this.trampleCounter;
            if (this.trampleCounter % 2 == 0) {
                this.mob.m_5496_(SoundEvents.f_12316_, 1.0f, 1.2f);
            }
        }
    }

    public static class GrenadeTossGoal
    extends Goal {
        private final BlundererEntity mob;
        private final double tossRange;
        private final int tossCooldown;
        private int cooldownTicks;
        private int retreatTicks;
        private LivingEntity target;
        private Vec3 retreatDirection;

        public GrenadeTossGoal(BlundererEntity mob, double tossRange, int tossCooldown) {
            this.mob = mob;
            this.tossRange = tossRange;
            this.tossCooldown = tossCooldown;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double distanceToTarget = this.mob.m_20280_((Entity)this.target);
            return distanceToTarget <= this.tossRange * this.tossRange && distanceToTarget > 25.0 && this.mob.m_142582_((Entity)this.target) && (double)this.mob.f_19796_.m_188501_() < 0.15;
        }

        public boolean m_8045_() {
            return this.mob.isTossingGrenade() || this.retreatTicks > 0;
        }

        public void m_8056_() {
            this.mob.setTossingGrenade(true);
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.retreatTicks = 0;
        }

        public void m_8037_() {
            if (this.mob.isTossingGrenade()) {
                if (this.target != null) {
                    this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                    this.mob.m_21573_().m_26573_();
                }
            } else if (this.retreatTicks == 0) {
                double dz;
                double dx;
                double distance;
                this.retreatTicks = 40;
                if (this.target != null && (distance = Math.sqrt((dx = this.mob.m_20185_() - this.target.m_20185_()) * dx + (dz = this.mob.m_20189_() - this.target.m_20189_()) * dz)) > 0.1) {
                    this.retreatDirection = new Vec3(dx / distance, 0.0, dz / distance);
                }
            } else {
                --this.retreatTicks;
                if (this.retreatDirection != null) {
                    Vec3 retreatPos = this.mob.m_20182_().m_82520_(this.retreatDirection.f_82479_ * 6.0, 0.0, this.retreatDirection.f_82481_ * 6.0);
                    this.mob.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, 1.2);
                }
            }
        }

        public void m_8041_() {
            this.cooldownTicks = this.tossCooldown;
            this.target = null;
            this.retreatTicks = 0;
            this.retreatDirection = null;
        }
    }
}

