/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.item.GunItem;

public class BlazeRodProjectileEntity
extends ProjectileEntity {
    private static final float PIERCE_CHANCE = 0.75f;
    private static final float SHATTER_CHANCE = 0.25f;
    private static final float POWDER_DROP_ON_SHATTER = 0.6f;
    private static final float ROD_DROP_NO_PIERCE = 0.95f;
    private static final float ROD_DROP_ONE_PIERCE = 0.75f;
    private static final float ROD_DROP_TWO_PIERCE = 0.5f;
    private static final float EXPLOSION_RADIUS = 2.5f;
    private static final float EXPLOSION_DAMAGE_FALLOFF = 0.7f;
    private static final int FIRE_DURATION = 3;
    private int remainingPenetrations = 2;
    private int mobsPierced = 0;
    private boolean hasShattered = false;
    private boolean pierceDecisionMade = false;
    private boolean willPierce = false;

    public BlazeRodProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public BlazeRodProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    public void m_8119_() {
        super.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult blockResult = BlazeRodProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            boolean hitBlock = false;
            if (blockResult.m_6662_() != HitResult.Type.MISS) {
                endVec = blockResult.m_82450_();
                hitBlock = true;
            }
            List<ProjectileEntity.EntityResult> hitEntities = this.findEntitiesOnPath(startVec, endVec);
            boolean hitSomething = false;
            while (this.remainingPenetrations > 0 && hitEntities != null && !hitEntities.isEmpty()) {
                ProjectileEntity.EntityResult closestEntity = null;
                double closestEntityDist = Double.MAX_VALUE;
                for (ProjectileEntity.EntityResult entity : hitEntities) {
                    double dist = startVec.m_82557_(entity.getHitPos());
                    if (!(dist < closestEntityDist)) continue;
                    closestEntityDist = dist;
                    closestEntity = entity;
                }
                if (closestEntity == null) break;
                this.onHitEntity(closestEntity.getEntity(), closestEntity.getHitPos(), startVec, endVec, closestEntity.isHeadshot());
                hitEntities.remove(closestEntity);
                hitSomething = true;
                if (!this.hasShattered && this.remainingPenetrations > 0) continue;
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            if (hitBlock) {
                BlockState state = this.m_9236_().m_8055_(blockResult.m_82425_());
                this.onHitBlock(state, blockResult.m_82425_(), blockResult.m_82434_(), blockResult.m_82450_().f_82479_, blockResult.m_82450_().f_82480_, blockResult.m_82450_().f_82481_);
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            if (hitSomething && this.remainingPenetrations <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        this.updateHeading();
        if (this.f_19797_ >= this.life) {
            this.onExpired();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        super.onHitBlock(state, pos, face, x, y, z);
        if (!this.m_9236_().f_46443_) {
            float dropChance = this.getBlockDropChance();
            if (this.f_19796_.m_188501_() < dropChance) {
                this.dropBlazeRod(x, y, z);
            } else {
                this.spawnFlameParticles(x, y, z);
                this.playExtinguishSound(x, y, z);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        float newDamage;
        if (entity.m_19879_() == this.shooterId) {
            return;
        }
        if (!this.pierceDecisionMade) {
            this.pierceDecisionMade = true;
            this.willPierce = this.f_19796_.m_188501_() < 0.75f;
        }
        float damage = this.getDamage();
        damage = newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage);
        damage *= this.advantageMultiplier(entity);
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        entity.m_6469_(source, damage);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.applyImpactEffect(livingEntity);
            if (this.f_19796_.m_188501_() < 0.75f) {
                entity.m_20254_(3);
            }
        }
        if (this.willPierce && this.remainingPenetrations > 0) {
            --this.remainingPenetrations;
            ++this.mobsPierced;
            entity.f_19802_ = 0;
            Vec3 motion = this.m_20184_();
            this.m_6034_(this.m_20185_() + motion.f_82479_ * 0.2, this.m_20186_() + motion.f_82480_ * 0.2, this.m_20189_() + motion.f_82481_ * 0.2);
            this.m_20256_(motion.m_82542_(0.85, 0.85, 0.85));
        } else {
            this.hasShattered = true;
            if (!this.m_9236_().f_46443_) {
                this.triggerMiniExplosion(hitVec, damage * 0.5f);
                if (this.f_19796_.m_188501_() < 0.6f) {
                    this.dropBlazePowder(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_);
                }
            }
            this.remainingPenetrations = 0;
        }
    }

    private void triggerMiniExplosion(Vec3 center, float baseDamage) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(center.f_82479_ - 2.5, center.f_82480_ - 2.5, center.f_82481_ - 2.5, center.f_82479_ + 2.5, center.f_82480_ + 2.5, center.f_82481_ + 2.5));
        DamageSource explosionSource = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        for (LivingEntity target : nearbyEntities) {
            double distance = target.m_20182_().m_82554_(center);
            if (distance > 2.5) continue;
            float distanceRatio = (float)(distance / 2.5);
            float damageMultiplier = 1.0f - distanceRatio * 0.3f;
            float explosionDamage = baseDamage * damageMultiplier;
            if (target == this.getShooter()) {
                explosionDamage *= 0.3f;
            }
            if (!((explosionDamage = this.applyProjectileProtection(target, explosionDamage)) > 0.5f)) continue;
            target.m_6469_(explosionSource, explosionDamage);
            if (!(this.f_19796_.m_188501_() < 0.5f * damageMultiplier)) continue;
            target.m_20254_(3);
        }
        this.spawnExplosionParticles(center);
    }

    private void spawnExplosionParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 20; ++i) {
                double angle = (double)i / 20.0 * 2.0 * Math.PI;
                double radius = 0.4 + this.f_19796_.m_188500_() * 0.6;
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                double speedX = offsetX * 0.15;
                double speedY = (this.f_19796_.m_188500_() - 0.3) * 0.2;
                double speedZ = offsetZ * 0.15;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.08);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, position.f_82479_, position.f_82480_, position.f_82481_, 8, 0.3, 0.3, 0.3, 0.2);
            for (i = 0; i < 10; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, 0.0, 0.1, 0.0, 0.05);
            }
        }
        this.m_9236_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.8f, 1.2f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
    }

    private void applyImpactEffect(LivingEntity target) {
        if (this.getProjectile().getImpactEffect() != null) {
            MobEffect effect;
            float effectChance = this.getProjectile().getImpactEffectChance();
            if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.getProjectile().getImpactEffect())) != null) {
                target.m_7292_(new MobEffectInstance(effect, this.getProjectile().getImpactEffectDuration(), this.getProjectile().getImpactEffectAmplifier()));
            }
        }
    }

    private float getBlockDropChance() {
        if (this.mobsPierced == 0) {
            return 0.95f;
        }
        if (this.mobsPierced == 1) {
            return 0.75f;
        }
        return 0.5f;
    }

    private void dropBlazeRod(double x, double y, double z) {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), x, y, z, new ItemStack((ItemLike)Items.f_42585_));
        double bounceStrength = 0.05;
        itemEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * bounceStrength, 0.2, (this.f_19796_.m_188500_() - 0.5) * bounceStrength);
        this.m_9236_().m_7967_((Entity)itemEntity);
        this.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
    }

    private void dropBlazePowder(double x, double y, double z) {
        ItemEntity powderEntity = new ItemEntity(this.m_9236_(), x, y, z, new ItemStack((ItemLike)Items.f_42593_));
        double bounceStrength = 0.15;
        powderEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * bounceStrength, 0.15, (this.f_19796_.m_188500_() - 0.5) * bounceStrength);
        this.m_9236_().m_7967_((Entity)powderEntity);
    }

    private void spawnFlameParticles(double x, double y, double z) {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 8, 0.2, 0.2, 0.2, 0.05);
    }

    private void playExtinguishSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
    }

    @Override
    protected void onProjectileTick() {
        super.onProjectileTick();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("RemainingPenetrations", this.remainingPenetrations);
        compound.m_128405_("MobsPierced", this.mobsPierced);
        compound.m_128379_("HasShattered", this.hasShattered);
        compound.m_128379_("PierceDecisionMade", this.pierceDecisionMade);
        compound.m_128379_("WillPierce", this.willPierce);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.remainingPenetrations = compound.m_128451_("RemainingPenetrations");
        this.mobsPierced = compound.m_128451_("MobsPierced");
        this.hasShattered = compound.m_128471_("HasShattered");
        this.pierceDecisionMade = compound.m_128471_("PierceDecisionMade");
        this.willPierce = compound.m_128471_("WillPierce");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.remainingPenetrations);
        buffer.writeInt(this.mobsPierced);
        buffer.writeBoolean(this.hasShattered);
        buffer.writeBoolean(this.pierceDecisionMade);
        buffer.writeBoolean(this.willPierce);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.remainingPenetrations = buffer.readInt();
        this.mobsPierced = buffer.readInt();
        this.hasShattered = buffer.readBoolean();
        this.pierceDecisionMade = buffer.readBoolean();
        this.willPierce = buffer.readBoolean();
    }
}

