/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.block.AutoTurretBlock;
import top.ribs.scguns.block.BasicTurretBlock;
import top.ribs.scguns.block.EnemyTurretBlock;
import top.ribs.scguns.block.ShotgunTurretBlock;
import top.ribs.scguns.block.SniperTurretBlock;
import top.ribs.scguns.blockentity.AutoTurretBlockEntity;
import top.ribs.scguns.blockentity.BasicTurretBlockEntity;
import top.ribs.scguns.blockentity.EnemyTurretBlockEntity;
import top.ribs.scguns.blockentity.ShotgunTurretBlockEntity;
import top.ribs.scguns.blockentity.SniperTurretBlockEntity;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.math.ExtendedEntityRayTraceResult;

public class LightningProjectileEntity
extends ProjectileEntity {
    private static final int MAX_BOUNCES = 3;
    private static final double BOUNCE_RANGE = 10.0;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.5f;
    private static final float BOUNCE_EFFECT_REDUCTION = 0.55f;
    private int bouncesLeft = 3;
    private float currentDamage;
    private final Set<Integer> hitEntities = new HashSet<Integer>();

    public LightningProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.currentDamage = this.getDamage();
    }

    public LightningProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        this.currentDamage = this.getDamage();
        this.hitEntities.add(shooter.m_19879_());
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        this.hitEntities.add(entity.m_19879_());
        this.currentDamage = this.applyProjectileProtection(livingEntity, this.currentDamage);
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (this.f_19796_.m_188501_() < 0.15f) {
                try {
                    if (!creeper.m_7090_()) {
                        CompoundTag nbt = new CompoundTag();
                        creeper.m_7380_(nbt);
                        nbt.m_128379_("powered", true);
                        creeper.m_7378_(nbt);
                        this.spawnLightningParticles(new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_()));
                    }
                }
                catch (Exception e) {
                    this.spawnLightningParticles(new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_()));
                }
            }
        }
        livingEntity.m_6469_(ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner()), this.currentDamage);
        Vec3 entityPosition = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_() * 0.5, entity.m_20189_());
        this.spawnLightningArc(this.m_20182_(), entityPosition);
        if (entity instanceof LivingEntity) {
            ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
            if (effectLocation != null) {
                MobEffect effect;
                float effectChance = this.getProjectile().getImpactEffectChance();
                if (headshot) {
                    effectChance = Math.min(1.0f, effectChance * 1.25f);
                }
                float bounceChanceMultiplier = (float)Math.pow(0.55f, 3 - this.bouncesLeft);
                effectChance *= bounceChanceMultiplier;
                if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                    int duration = this.getProjectile().getImpactEffectDuration();
                    if (headshot) {
                        duration = (int)((float)duration * 1.5f);
                    }
                    float bounceMultiplier = (float)Math.pow(0.55f, 3 - this.bouncesLeft);
                    duration = (int)((float)duration * bounceMultiplier);
                    int amplifier = Math.max(0, this.getProjectile().getImpactEffectAmplifier() - (3 - this.bouncesLeft));
                    livingEntity.m_7292_(new MobEffectInstance(effect, duration, amplifier));
                }
            }
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), livingEntity);
        }
        if (this.bouncesLeft > 0) {
            --this.bouncesLeft;
            this.currentDamage *= 0.75f;
            LivingEntity nextTarget = this.findNextTarget(entity);
            if (nextTarget != null) {
                this.scheduleBounce(nextTarget, entityPosition);
            } else {
                this.m_146870_();
            }
        } else {
            this.m_146870_();
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
    }

    private void scheduleBounce(LivingEntity nextTarget, Vec3 previousPosition) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> this.bounceToNextTarget(nextTarget, previousPosition));
        }
    }

    @Override
    public float applyProjectileProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44969_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.1f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    private void bounceToNextTarget(LivingEntity nextTarget, Vec3 previousPosition) {
        if (nextTarget.m_19879_() == this.getShooterId() || nextTarget == this.getShooter() || nextTarget == this.getOwner()) {
            this.m_146870_();
            return;
        }
        Vec3 direction = nextTarget.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        this.m_20256_(direction.m_82490_(1.5));
        this.m_6034_(nextTarget.m_20185_(), nextTarget.m_20186_() + (double)nextTarget.m_20192_() * 0.5, nextTarget.m_20189_());
        Vec3 nextTargetPosition = new Vec3(nextTarget.m_20185_(), nextTarget.m_20186_() + (double)nextTarget.m_20192_() * 0.5, nextTarget.m_20189_());
        this.spawnLightningArc(previousPosition, nextTargetPosition);
        this.onHitEntity((Entity)nextTarget, nextTargetPosition, this.m_20182_(), nextTargetPosition, false);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        BlockEntity turret;
        BlockEntity blockEntity;
        if (state.m_60734_() instanceof AutoTurretBlock && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof AutoTurretBlockEntity) {
            turret = (AutoTurretBlockEntity)blockEntity;
            turret.onHitByLightningProjectile();
        }
        if (state.m_60734_() instanceof SniperTurretBlock && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof SniperTurretBlockEntity) {
            turret = (SniperTurretBlockEntity)blockEntity;
            turret.onHitByLightningProjectile();
        }
        if (state.m_60734_() instanceof BasicTurretBlock && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof BasicTurretBlockEntity) {
            turret = (BasicTurretBlockEntity)blockEntity;
            turret.onHitByLightningProjectile();
        }
        if (state.m_60734_() instanceof ShotgunTurretBlock && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof ShotgunTurretBlockEntity) {
            turret = (ShotgunTurretBlockEntity)blockEntity;
            turret.onHitByLightningProjectile();
        }
        if (state.m_60734_() instanceof EnemyTurretBlock && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof EnemyTurretBlockEntity) {
            turret = (EnemyTurretBlockEntity)blockEntity;
            turret.onHitByLightningProjectile();
        }
        this.spawnLightningParticles(new Vec3(x, y + 0.1, z));
        this.m_146870_();
    }

    @Override
    public void onExpired() {
        this.spawnLightningParticles(new Vec3(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_()));
    }

    private void spawnLightningArc(Vec3 start, Vec3 end) {
        if (!this.m_9236_().f_46443_) {
            if (this.getShooter() != null) {
                Vec3 shooterPos = new Vec3(this.getShooter().m_20185_(), this.getShooter().m_20186_() + (double)this.getShooter().m_20192_() * 0.5, this.getShooter().m_20189_());
                double distanceToShooterStart = start.m_82554_(shooterPos);
                double distanceToShooterEnd = end.m_82554_(shooterPos);
                if (distanceToShooterStart < 1.0 || distanceToShooterEnd < 1.0) {
                    return;
                }
            }
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            Vec3 direction = end.m_82546_(start);
            double distance = direction.m_82553_();
            direction = direction.m_82541_();
            double stepSize = 0.1;
            for (double d = 0.0; d < distance; d += stepSize) {
                Vec3 particlePos = start.m_82549_(direction.m_82490_(d));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnLightningParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            int particleCount = 20;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, position.f_82479_, position.f_82480_, position.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.1);
        }
    }

    @Override
    @Nullable
    protected List<ProjectileEntity.EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<ProjectileEntity.EntityResult> hitEntities = new ArrayList<ProjectileEntity.EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            ProjectileEntity.EntityResult result;
            if (entity.m_19879_() == this.getShooterId() || entity == this.getShooter() || entity == this.getOwner() || entity.equals((Object)this.shooter) || this.hitEntities.contains(entity.m_19879_()) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Override
    @Nullable
    protected ProjectileEntity.EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            Vec3 hitPos;
            double distanceToHit;
            ProjectileEntity.EntityResult result;
            if (entity.m_19879_() == this.getShooterId() || entity == this.getShooter() || entity == this.getOwner() || entity.equals((Object)this.shooter) || this.hitEntities.contains(entity.m_19879_()) || (result = this.getHitResult(entity, startVec, endVec)) == null || !((distanceToHit = startVec.m_82554_(hitPos = result.getHitPos())) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new ProjectileEntity.EntityResult(hitEntity, hitVec, headshot) : null;
    }

    private LivingEntity findNextTarget(Entity currentTarget) {
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, currentTarget.m_20191_().m_82400_(10.0));
        nearbyEntities.removeIf(entity -> this.hitEntities.contains(entity.m_19879_()) || entity == this.getOwner() || entity == currentTarget || entity == this.getShooter() || entity.m_19879_() == this.getShooterId());
        if (!nearbyEntities.isEmpty()) {
            return (LivingEntity)nearbyEntities.get(0);
        }
        return null;
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return;
        }
        this.updateHeading();
        this.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            List<ProjectileEntity.EntityResult> hitEntitiesList;
            BlockHitResult blockResult;
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            ClipContext fluidContext = new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this);
            BlockHitResult fluidResult = this.m_9236_().m_45547_(fluidContext);
            if (fluidResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = fluidResult.m_82425_();
                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                FluidState fluidState = blockState.m_60819_();
                if (fluidState.m_205070_(FluidTags.f_13131_)) {
                    if (((Boolean)Config.CLIENT.particle.enableWaterImpactParticles.get()).booleanValue()) {
                        this.onWaterImpact(fluidResult.m_82450_());
                    } else {
                        this.m_9236_().m_6263_(null, fluidResult.m_82450_().f_82479_, fluidResult.m_82450_().f_82480_, fluidResult.m_82450_().f_82481_, SoundEvents.f_12277_, SoundSource.NEUTRAL, 1.2f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                    }
                } else if (fluidState.m_205070_(FluidTags.f_13132_)) {
                    this.onLavaImpact(fluidResult.m_82450_());
                }
            }
            if ((blockResult = LightningProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES)).m_6662_() != HitResult.Type.MISS) {
                endVec = blockResult.m_82450_();
            }
            if (!(hitEntitiesList = this.findCustomEntitiesOnPath(startVec, endVec)).isEmpty()) {
                for (ProjectileEntity.EntityResult entityResult : hitEntitiesList) {
                    ExtendedEntityRayTraceResult result = new ExtendedEntityRayTraceResult(entityResult);
                    Entity entity = result.m_82443_();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (this.shooter instanceof Player && !((Player)this.shooter).m_7099_(player)) continue;
                    }
                    this.onHit((HitResult)result, startVec, endVec);
                }
            } else if (blockResult.m_6662_() != HitResult.Type.MISS) {
                this.onHit((HitResult)blockResult, startVec, endVec);
            }
        }
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private List<ProjectileEntity.EntityResult> findCustomEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<ProjectileEntity.EntityResult> hitEntitiesList = new ArrayList<ProjectileEntity.EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            ProjectileEntity.EntityResult result;
            if (entity.m_19879_() == this.getShooterId() || entity == this.getShooter() || entity == this.getOwner() || entity.equals((Object)this.shooter) || this.hitEntities.contains(entity.m_19879_()) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntitiesList.add(result);
        }
        return hitEntitiesList;
    }
}

