/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class SculkCellEntity
extends ProjectileEntity {
    private static final float SHIELD_DISABLE_CHANCE = 0.3f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.7f;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.5f;
    private static final float CRITICAL_EFFECT_MULTIPLIER = 1.25f;

    public SculkCellEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public SculkCellEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ < this.life) {
            if (this.f_19797_ % 2 == 0) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SONIC_BLAST.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (this.f_19797_ > 1 && this.f_19797_ % 4 == 0) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_235898_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingTarget;
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        damage *= this.advantageMultiplier(entity);
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        if (entity instanceof LivingEntity) {
            livingTarget = (LivingEntity)entity;
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage, 0.3f);
        if (blocked) {
            float penetratingDamage = damage * 0.7f;
            entity.m_6469_(source, penetratingDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.applyEffect(livingEntity, 0.7f, headshot, critical);
            }
        } else {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.applyEffect(livingEntity, 1.0f, headshot, critical);
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
    }

    private void applyEffect(LivingEntity target, float powerMultiplier, boolean headshot, boolean critical) {
        ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
        if (effectLocation != null) {
            MobEffect effect;
            float effectChance = this.getProjectile().getImpactEffectChance() * powerMultiplier;
            if (headshot) {
                effectChance = Math.min(1.0f, effectChance * 1.25f);
            }
            if (critical) {
                effectChance = Math.min(1.0f, effectChance * 1.25f);
            }
            if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                int duration = this.getProjectile().getImpactEffectDuration();
                if (headshot) {
                    duration = (int)((float)duration * 1.5f);
                }
                if (critical) {
                    duration = (int)((float)duration * 1.25f);
                }
                duration = (int)((float)duration * powerMultiplier);
                int amplifier = this.getProjectile().getImpactEffectAmplifier();
                if (critical) {
                    ++amplifier;
                }
                target.m_7292_(new MobEffectInstance(effect, duration, amplifier));
                if (!this.m_9236_().f_46443_) {
                    ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                    for (int i = 0; i < 3; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, target.m_20185_() + (this.f_19796_.m_188500_() - 0.5), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_() + (this.f_19796_.m_188500_() - 0.5), 1, 0.0, 0.05, 0.0, 0.1);
                    }
                }
            }
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
        if (!this.m_9236_().f_46443_) {
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 5; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
            for (i = 0; i < 2; ++i) {
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SONIC_BLAST.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        super.onHitBlock(state, pos, face, x, y, z);
    }

    @Override
    public void onExpired() {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 8; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.02);
            }
        }
    }
}

