/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.raid;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.Config;
import top.ribs.scguns.config.RaidConfig;
import top.ribs.scguns.entity.raid.RaidSaveData;

public class ActiveRaid {
    private static final int BOSS_REVALIDATION_INTERVAL = 100;
    private static final int TARGET_UPDATE_INTERVAL = 40;
    private static final int BOSS_VALIDATION_TICKS = 600;
    private final UUID raidId = UUID.randomUUID();
    private final Integer raidLevel;
    private final RaidConfig.RaidData config;
    private final ServerLevel level;
    private final Vec3 spawnCenter;
    private final long startTime;
    private UUID bossUUID;
    private UUID mountUUID;
    private UUID targetPlayerUUID;
    private final Set<UUID> henchmenUUIDs;
    private int spawnTimer;
    private int totalHenchmenSpawned;
    private boolean isActive;
    private boolean bossConfirmed;
    private ServerBossEvent bossBar;
    private int ticksSinceLoad = 0;
    private int ticksSinceLastValidation = 0;
    private int ticksSinceTargetUpdate = 0;
    private int ticksSinceStart = 0;

    public ActiveRaid(Integer raidLevel, RaidConfig.RaidData config, ServerLevel level, Vec3 spawnCenter, long startTime) {
        this.raidLevel = raidLevel;
        this.config = config;
        this.level = level;
        this.spawnCenter = spawnCenter;
        this.startTime = startTime;
        this.henchmenUUIDs = new HashSet<UUID>();
        this.spawnTimer = config.henchmen().spawnIntervalTicks();
        this.totalHenchmenSpawned = 0;
        this.isActive = true;
        this.bossConfirmed = false;
        this.mountUUID = null;
        this.targetPlayerUUID = null;
        this.ticksSinceStart = 0;
        this.ticksSinceLoad = 0;
        this.ticksSinceLastValidation = 0;
        this.ticksSinceTargetUpdate = 0;
        this.createBossBar();
    }

    public static ActiveRaid restore(RaidSaveData.ActiveRaidData data, RaidConfig.RaidData config, ServerLevel level) {
        ActiveRaid raid = new ActiveRaid(data.raidLevel(), config, level, data.spawnCenter(), data.startTime());
        raid.bossUUID = data.bossUUID();
        raid.mountUUID = data.mountUUID();
        raid.targetPlayerUUID = data.targetPlayerUUID();
        raid.henchmenUUIDs.addAll(data.henchmenUUIDs());
        raid.spawnTimer = data.spawnTimer();
        raid.totalHenchmenSpawned = data.totalSpawned();
        raid.isActive = data.isActive();
        raid.bossConfirmed = false;
        raid.ticksSinceLoad = 0;
        long elapsedTime = level.m_46467_() - data.startTime();
        raid.ticksSinceStart = (int)Math.min(elapsedTime, Integer.MAX_VALUE);
        return raid;
    }

    private void createBossBar() {
        String bossName = this.config.boss().customName();
        MutableComponent title = bossName != null && bossName.startsWith("translation:") ? Component.m_237115_((String)bossName.substring(12)) : (bossName != null ? Component.m_237113_((String)bossName) : Component.m_237113_((String)("Raid Boss: " + this.config.raidId())));
        this.bossBar = new ServerBossEvent((Component)title, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
        this.bossBar.m_142711_(1.0f);
        this.bossBar.m_8321_(true);
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public ServerBossEvent getBossBar() {
        return this.bossBar;
    }

    public void tick() {
        Entity mount;
        LivingEntity boss;
        int timeoutTicks;
        if (!this.isActive) {
            return;
        }
        ++this.ticksSinceLoad;
        ++this.ticksSinceLastValidation;
        ++this.ticksSinceTargetUpdate;
        ++this.ticksSinceStart;
        int timeoutMinutes = (Integer)Config.COMMON.raids.raidTimeoutMinutes.get();
        if (timeoutMinutes > 0 && this.ticksSinceStart >= (timeoutTicks = timeoutMinutes * 60 * 20)) {
            this.announceToNearbyPlayers((Component)Component.m_237115_((String)"raid.scguns.timeout").m_130940_(ChatFormatting.RED), Math.max(256.0, (double)this.config.spawnConditions().searchRadius()));
            this.endRaid(false);
            return;
        }
        if (!this.validateBoss()) {
            return;
        }
        if (this.ticksSinceLastValidation >= 100) {
            this.revalidateRaidState();
            this.ticksSinceLastValidation = 0;
        }
        if (this.ticksSinceTargetUpdate >= 40) {
            this.updateMobTargets();
            this.ticksSinceTargetUpdate = 0;
        }
        if ((boss = this.getBoss()) == null || !boss.m_6084_()) {
            this.endRaid(this.bossConfirmed);
            return;
        }
        if (!(this.mountUUID == null || (mount = this.getMount()) != null && mount.m_6084_())) {
            this.mountUUID = null;
        }
        this.updateBossBar();
        if (this.level.m_46467_() % 20L == 0L) {
            this.updateBossBarPlayers();
        }
        if (this.bossConfirmed && this.spawnTimer > 0) {
            --this.spawnTimer;
        }
    }

    private void updateMobTargets() {
        PathfinderMob pathfinderBoss;
        ServerPlayer targetPlayer = this.getTargetPlayer(this.level);
        if ((targetPlayer == null || targetPlayer.m_213877_() || targetPlayer.m_5833_() || targetPlayer.m_7500_() || !targetPlayer.m_6084_()) && (targetPlayer = this.findNewTargetPlayer()) != null) {
            this.targetPlayerUUID = targetPlayer.m_20148_();
        }
        if (targetPlayer == null) {
            return;
        }
        LivingEntity boss = this.getBoss();
        if (boss instanceof PathfinderMob && (pathfinderBoss = (PathfinderMob)boss).m_5448_() == null) {
            pathfinderBoss.m_6710_((LivingEntity)targetPlayer);
            if (boss instanceof AbstractPiglin) {
                AbstractPiglin abstractPiglin = (AbstractPiglin)boss;
                try {
                    Brain brain = abstractPiglin.m_6274_();
                    brain.m_21936_(MemoryModuleType.f_26334_);
                    brain.m_21879_(MemoryModuleType.f_26334_, (Object)targetPlayer.m_20148_());
                    brain.m_21936_(MemoryModuleType.f_26335_);
                    brain.m_21879_(MemoryModuleType.f_26335_, (Object)true);
                    brain.m_21879_(MemoryModuleType.f_26372_, (Object)targetPlayer);
                    brain.m_21936_(MemoryModuleType.f_26368_);
                    brain.m_21879_(MemoryModuleType.f_26368_, (Object)targetPlayer);
                    abstractPiglin.m_6703_((LivingEntity)targetPlayer);
                }
                catch (Exception brain) {
                    // empty catch block
                }
            }
        }
        for (UUID henchmanUUID : this.henchmenUUIDs) {
            PathfinderMob pathfinderMob;
            Entity entity = this.level.m_8791_(henchmanUUID);
            if (!(entity instanceof PathfinderMob) || (pathfinderMob = (PathfinderMob)entity).m_5448_() != null) continue;
            pathfinderMob.m_6710_((LivingEntity)targetPlayer);
            if (!(entity instanceof AbstractPiglin)) continue;
            AbstractPiglin abstractPiglin = (AbstractPiglin)entity;
            try {
                Brain brain = abstractPiglin.m_6274_();
                brain.m_21936_(MemoryModuleType.f_26334_);
                brain.m_21879_(MemoryModuleType.f_26334_, (Object)targetPlayer.m_20148_());
                brain.m_21936_(MemoryModuleType.f_26335_);
                brain.m_21879_(MemoryModuleType.f_26335_, (Object)true);
                brain.m_21879_(MemoryModuleType.f_26372_, (Object)targetPlayer);
                brain.m_21936_(MemoryModuleType.f_26368_);
                brain.m_21879_(MemoryModuleType.f_26368_, (Object)targetPlayer);
                abstractPiglin.m_6703_((LivingEntity)targetPlayer);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    private ServerPlayer findNewTargetPlayer() {
        List nearbyPlayers = this.level.m_8795_(player -> !player.m_5833_() && !player.m_7500_() && player.m_6084_() && player.m_20182_().m_82554_(this.spawnCenter) <= (double)this.config.spawnConditions().searchRadius());
        if (nearbyPlayers.isEmpty()) {
            return null;
        }
        ServerPlayer closest = null;
        double closestDist = Double.MAX_VALUE;
        for (ServerPlayer player2 : nearbyPlayers) {
            double dist = player2.m_20182_().m_82554_(this.spawnCenter);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closest = player2;
        }
        return closest;
    }

    private boolean validateBoss() {
        if (this.bossUUID == null) {
            this.endRaid(false);
            return false;
        }
        if (this.bossConfirmed) {
            return true;
        }
        LivingEntity boss = this.getBoss();
        if (boss != null && boss.m_6084_()) {
            this.bossConfirmed = true;
            this.ticksSinceLoad = 0;
            boss.m_6034_(this.spawnCenter.f_82479_, this.spawnCenter.f_82480_, this.spawnCenter.f_82481_);
            return true;
        }
        if (this.ticksSinceLoad >= 600) {
            this.endRaid(false);
            return false;
        }
        if (this.ticksSinceLoad % 20 == 0) {
            ChunkPos chunkPos = new ChunkPos(new BlockPos((int)this.spawnCenter.f_82479_, (int)this.spawnCenter.f_82480_, (int)this.spawnCenter.f_82481_));
            this.level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        }
        return false;
    }

    private void revalidateRaidState() {
        this.henchmenUUIDs.removeIf(uuid -> {
            Entity entity = this.level.m_8791_(uuid);
            if (!(entity instanceof LivingEntity)) {
                return true;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            return !livingEntity.m_6084_();
        });
    }

    public void updateBossBarPlayers() {
        if (this.bossBar == null) {
            return;
        }
        LivingEntity boss = this.getBoss();
        if (boss == null || !boss.m_6084_()) {
            return;
        }
        List nearbyPlayers = this.level.m_8795_(player -> {
            if (!player.m_6084_() || player.m_213877_() || player.m_5833_()) {
                return false;
            }
            double distance = player.m_20182_().m_82554_(boss.m_20182_());
            return distance <= 128.0;
        });
        HashSet currentPlayersSet = new HashSet(this.bossBar.m_8324_());
        for (ServerPlayer player2 : currentPlayersSet) {
            if (nearbyPlayers.contains(player2) && player2.m_6084_() && !player2.m_213877_()) continue;
            this.bossBar.m_6539_(player2);
        }
        for (ServerPlayer player2 : nearbyPlayers) {
            if (currentPlayersSet.contains(player2)) continue;
            this.bossBar.m_6543_(player2);
        }
    }

    private void updateBossBar() {
        if (this.bossBar == null) {
            return;
        }
        LivingEntity boss = this.getBoss();
        if (boss != null && boss.m_6084_()) {
            float healthPercent = boss.m_21223_() / boss.m_21233_();
            this.bossBar.m_142711_(Math.max(0.0f, Math.min(1.0f, healthPercent)));
        } else if (this.bossConfirmed) {
            this.bossBar.m_142711_(0.0f);
        }
    }

    public void onBossDefeated() {
        this.endRaid(true);
    }

    public UUID getRaidId() {
        return this.raidId;
    }

    public Integer getRaidLevel() {
        return this.raidLevel;
    }

    public RaidConfig.RaidData getConfig() {
        return this.config;
    }

    public Vec3 getSpawnCenter() {
        return this.spawnCenter;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSpawnTimer() {
        return this.spawnTimer;
    }

    public int getTotalHenchmenSpawned() {
        return this.totalHenchmenSpawned;
    }

    public boolean isBossConfirmed() {
        return this.bossConfirmed;
    }

    public void setBossUUID(UUID bossUUID) {
        this.bossUUID = bossUUID;
        this.bossConfirmed = false;
    }

    @Nullable
    public UUID getBossUUID() {
        return this.bossUUID;
    }

    public void setMountUUID(UUID mountUUID) {
        this.mountUUID = mountUUID;
    }

    @Nullable
    public UUID getMountUUID() {
        return this.mountUUID;
    }

    public void setTargetPlayer(UUID playerUUID) {
        this.targetPlayerUUID = playerUUID;
    }

    @Nullable
    public UUID getTargetPlayerUUID() {
        return this.targetPlayerUUID;
    }

    @Nullable
    public ServerPlayer getTargetPlayer(ServerLevel level) {
        if (this.targetPlayerUUID == null) {
            return null;
        }
        return level.m_7654_().m_6846_().m_11259_(this.targetPlayerUUID);
    }

    @Nullable
    public LivingEntity getBoss() {
        if (this.bossUUID == null) {
            return null;
        }
        Entity entity = this.level.m_8791_(this.bossUUID);
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Nullable
    public Entity getMount() {
        if (this.mountUUID == null) {
            return null;
        }
        return this.level.m_8791_(this.mountUUID);
    }

    public void addHenchman(UUID uuid) {
        this.henchmenUUIDs.add(uuid);
        ++this.totalHenchmenSpawned;
    }

    public void removeHenchman(UUID uuid) {
        this.henchmenUUIDs.remove(uuid);
    }

    public int getAliveHenchmenCount() {
        this.revalidateRaidState();
        return this.henchmenUUIDs.size();
    }

    public Set<UUID> getHenchmenUUIDs() {
        return new HashSet<UUID>(this.henchmenUUIDs);
    }

    public boolean canSpawnMoreHenchmen() {
        return this.getAliveHenchmenCount() < this.config.henchmen().maxAlive();
    }

    public boolean shouldSpawnHenchmen() {
        return this.spawnTimer <= 0 && this.canSpawnMoreHenchmen() && this.isActive && this.bossConfirmed;
    }

    public void resetSpawnTimer() {
        this.spawnTimer = this.config.henchmen().spawnIntervalTicks();
    }

    public void endRaid(boolean bossDefeated) {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        if (bossDefeated) {
            this.announceToNearbyPlayers((Component)Component.m_237115_((String)"raid.scguns.defeated"), 64.0);
        } else {
            this.announceToNearbyPlayers((Component)Component.m_237115_((String)"raid.scguns.failed"), 64.0);
        }
        if (this.bossBar != null) {
            this.bossBar.m_8321_(false);
            this.bossBar.m_7706_();
        }
        this.cleanupBoss(bossDefeated);
        this.cleanupHenchmen(bossDefeated);
        this.cleanupMount(bossDefeated);
    }

    private void cleanupBoss(boolean wasBossDefeated) {
        if (this.bossUUID == null) {
            return;
        }
        Entity entity = this.level.m_8791_(this.bossUUID);
        if (entity instanceof Mob) {
            Mob boss = (Mob)entity;
            boss.m_20137_("RaidBoss");
            boss.m_20137_("RaidMember_" + this.raidId);
            if (!wasBossDefeated && boss.m_6084_()) {
                boss.m_146870_();
            }
        }
    }

    private void cleanupHenchmen(boolean wasBossDefeated) {
        for (UUID uuid : new HashSet<UUID>(this.henchmenUUIDs)) {
            Entity entity = this.level.m_8791_(uuid);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            mob.m_20137_("RaidHenchman");
            mob.m_20137_("RaidMember_" + this.raidId);
            if (wasBossDefeated || !mob.m_6084_()) continue;
            mob.m_146870_();
        }
        this.henchmenUUIDs.clear();
    }

    private void cleanupMount(boolean wasBossDefeated) {
        Entity entity;
        if (this.mountUUID != null && (entity = this.level.m_8791_(this.mountUUID)) instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_20137_("RaidMount");
            mob.m_20137_("RaidMember_" + this.raidId);
            if (!wasBossDefeated && mob.m_6084_()) {
                mob.m_146870_();
            }
        }
    }

    public void announceToNearbyPlayers(Component message, double radius) {
        List nearbyPlayers = this.level.m_8795_(player -> player.m_20182_().m_82554_(this.spawnCenter) <= radius);
        for (ServerPlayer player2 : nearbyPlayers) {
            player2.m_213846_(message);
        }
    }

    public long getRaidDuration() {
        return this.level.m_46467_() - this.startTime;
    }

    public int getRemainingTicks() {
        int timeoutMinutes = (Integer)Config.COMMON.raids.raidTimeoutMinutes.get();
        if (timeoutMinutes <= 0) {
            return -1;
        }
        int timeoutTicks = timeoutMinutes * 60 * 20;
        return Math.max(0, timeoutTicks - this.ticksSinceStart);
    }

    public int getRemainingMinutes() {
        int remainingTicks = this.getRemainingTicks();
        if (remainingTicks < 0) {
            return -1;
        }
        return remainingTicks / 1200;
    }

    public void setBossConfirmed(boolean b) {
        this.bossConfirmed = b;
    }
}

