/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.raid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.entity.raid.ActiveRaid;

public class RaidSaveData
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_NAME = "scguns_raid_save_data";
    private final Map<UUID, ActiveRaidData> activeRaidData = new HashMap<UUID, ActiveRaidData>();
    private final Map<ResourceLocation, ScheduledRaidData> scheduledRaids = new HashMap<ResourceLocation, ScheduledRaidData>();
    private final Map<ResourceLocation, Long> lastRaidDayByDimension = new HashMap<ResourceLocation, Long>();

    public static RaidSaveData get(ServerLevel level) {
        return (RaidSaveData)level.m_7654_().m_129783_().m_8895_().m_164861_(RaidSaveData::load, RaidSaveData::new, DATA_NAME);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag activeRaidsList = new ListTag();
        for (ActiveRaidData activeRaidData : this.activeRaidData.values()) {
            activeRaidsList.add((Object)activeRaidData.save());
        }
        tag.m_128365_("ActiveRaids", (Tag)activeRaidsList);
        ListTag scheduledRaidsList = new ListTag();
        for (ScheduledRaidData data : this.scheduledRaids.values()) {
            scheduledRaidsList.add((Object)data.save());
        }
        tag.m_128365_("ScheduledRaids", (Tag)scheduledRaidsList);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<ResourceLocation, Long> entry : this.lastRaidDayByDimension.entrySet()) {
            compoundTag.m_128356_(entry.getKey().toString(), entry.getValue().longValue());
        }
        tag.m_128365_("LastRaidDays", (Tag)compoundTag);
        return tag;
    }

    public static RaidSaveData load(CompoundTag tag) {
        Record raidData;
        int i;
        RaidSaveData data = new RaidSaveData();
        if (tag.m_128441_("ActiveRaids")) {
            ListTag activeRaidsList = tag.m_128437_("ActiveRaids", 10);
            for (i = 0; i < activeRaidsList.size(); ++i) {
                raidData = ActiveRaidData.load(activeRaidsList.m_128728_(i));
                if (raidData == null) continue;
                data.activeRaidData.put(raidData.raidId, (ActiveRaidData)raidData);
            }
        }
        if (tag.m_128441_("ScheduledRaids")) {
            ListTag scheduledRaidsList = tag.m_128437_("ScheduledRaids", 10);
            for (i = 0; i < scheduledRaidsList.size(); ++i) {
                raidData = ScheduledRaidData.load(scheduledRaidsList.m_128728_(i));
                if (raidData == null) continue;
                data.scheduledRaids.put(((ScheduledRaidData)raidData).dimension, (ScheduledRaidData)raidData);
            }
        }
        if (tag.m_128441_("LastRaidDays")) {
            CompoundTag lastRaidDaysTag = tag.m_128469_("LastRaidDays");
            for (String key : lastRaidDaysTag.m_128431_()) {
                try {
                    ResourceLocation dimension = new ResourceLocation(key);
                    long lastDay = lastRaidDaysTag.m_128454_(key);
                    data.lastRaidDayByDimension.put(dimension, lastDay);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load last raid day for dimension: {}", (Object)key);
                }
            }
        }
        return data;
    }

    public void saveActiveRaid(ActiveRaid raid) {
        ActiveRaidData data = new ActiveRaidData(raid.getRaidId(), raid.getConfig().raidId(), raid.getRaidLevel(), raid.getSpawnCenter(), raid.getStartTime(), raid.getBossUUID(), raid.getMountUUID(), raid.getTargetPlayerUUID(), raid.getHenchmenUUIDs(), raid.getSpawnTimer(), raid.getTotalHenchmenSpawned(), raid.isActive(), raid.isBossConfirmed());
        this.activeRaidData.put(raid.getRaidId(), data);
        this.m_77762_();
    }

    public void removeActiveRaid(UUID raidId) {
        if (this.activeRaidData.remove(raidId) != null) {
            this.m_77762_();
        }
    }

    public Collection<ActiveRaidData> getActiveRaidData() {
        return new ArrayList<ActiveRaidData>(this.activeRaidData.values());
    }

    public void scheduleRaid(ResourceLocation dimension, ServerPlayer player, String raidId, long day) {
        ScheduledRaidData data = new ScheduledRaidData(dimension, player.m_20148_(), raidId, day);
        this.scheduledRaids.put(dimension, data);
        this.m_77762_();
    }

    @Nullable
    public ScheduledRaidData getScheduledRaid(ResourceLocation dimension) {
        return this.scheduledRaids.get(dimension);
    }

    public void removeScheduledRaid(ResourceLocation dimension) {
        if (this.scheduledRaids.remove(dimension) != null) {
            this.m_77762_();
        }
    }

    public void setLastRaidDay(ResourceLocation dimension, long day) {
        this.lastRaidDayByDimension.put(dimension, day);
        this.m_77762_();
    }

    public long getLastRaidDay(ResourceLocation dimension) {
        return this.lastRaidDayByDimension.getOrDefault(dimension, -1000L);
    }

    public boolean canScheduleRaid(ResourceLocation dimension, long currentDay, int minDaysBetween) {
        long lastRaidDay = this.getLastRaidDay(dimension);
        return currentDay - lastRaidDay >= (long)minDaysBetween;
    }

    public void cleanupInvalidRaids(ServerLevel level) {
        Iterator<Map.Entry<UUID, ActiveRaidData>> iterator = this.activeRaidData.entrySet().iterator();
        int removed = 0;
        while (iterator.hasNext()) {
            Map.Entry<UUID, ActiveRaidData> entry = iterator.next();
            ActiveRaidData data = entry.getValue();
            if (!data.isActive) {
                iterator.remove();
                ++removed;
                continue;
            }
            if (level.m_8791_(data.bossUUID) != null || !data.bossConfirmed) continue;
            iterator.remove();
            ++removed;
        }
        if (removed > 0) {
            this.m_77762_();
        }
    }

    public record ActiveRaidData(UUID raidId, String configRaidId, @Nullable Integer raidLevel, Vec3 spawnCenter, long startTime, UUID bossUUID, @Nullable UUID mountUUID, @Nullable UUID targetPlayerUUID, Set<UUID> henchmenUUIDs, int spawnTimer, int totalSpawned, boolean isActive, boolean bossConfirmed) {
        public ActiveRaidData(UUID raidId, String configRaidId, @Nullable Integer raidLevel, Vec3 spawnCenter, long startTime, UUID bossUUID, @Nullable UUID mountUUID, @Nullable UUID targetPlayerUUID, Set<UUID> henchmenUUIDs, int spawnTimer, int totalSpawned, boolean isActive, boolean bossConfirmed) {
            this.raidId = raidId;
            this.configRaidId = configRaidId;
            this.raidLevel = raidLevel;
            this.spawnCenter = spawnCenter;
            this.startTime = startTime;
            this.bossUUID = bossUUID;
            this.mountUUID = mountUUID;
            this.targetPlayerUUID = targetPlayerUUID;
            this.henchmenUUIDs = new HashSet<UUID>(henchmenUUIDs);
            this.spawnTimer = spawnTimer;
            this.totalSpawned = totalSpawned;
            this.isActive = isActive;
            this.bossConfirmed = bossConfirmed;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("RaidId", this.raidId);
            tag.m_128359_("ConfigRaidId", this.configRaidId);
            if (this.raidLevel != null) {
                tag.m_128405_("RaidLevel", this.raidLevel.intValue());
            }
            tag.m_128347_("SpawnX", this.spawnCenter.f_82479_);
            tag.m_128347_("SpawnY", this.spawnCenter.f_82480_);
            tag.m_128347_("SpawnZ", this.spawnCenter.f_82481_);
            tag.m_128356_("StartTime", this.startTime);
            tag.m_128362_("BossUUID", this.bossUUID);
            if (this.mountUUID != null) {
                tag.m_128362_("MountUUID", this.mountUUID);
            }
            if (this.targetPlayerUUID != null) {
                tag.m_128362_("TargetPlayerUUID", this.targetPlayerUUID);
            }
            ListTag henchmenList = new ListTag();
            for (UUID uuid : this.henchmenUUIDs) {
                CompoundTag henchmanTag = new CompoundTag();
                henchmanTag.m_128362_("UUID", uuid);
                henchmenList.add((Object)henchmanTag);
            }
            tag.m_128365_("Henchmen", (Tag)henchmenList);
            tag.m_128405_("SpawnTimer", this.spawnTimer);
            tag.m_128405_("TotalSpawned", this.totalSpawned);
            tag.m_128379_("IsActive", this.isActive);
            tag.m_128379_("BossConfirmed", this.bossConfirmed);
            return tag;
        }

        @Nullable
        public static ActiveRaidData load(CompoundTag tag) {
            try {
                UUID raidId = tag.m_128342_("RaidId");
                String configRaidId = tag.m_128461_("ConfigRaidId");
                Integer raidLevel = null;
                if (tag.m_128441_("RaidLevel")) {
                    raidLevel = tag.m_128451_("RaidLevel");
                }
                Vec3 spawnCenter = new Vec3(tag.m_128459_("SpawnX"), tag.m_128459_("SpawnY"), tag.m_128459_("SpawnZ"));
                long startTime = tag.m_128454_("StartTime");
                UUID bossUUID = tag.m_128342_("BossUUID");
                UUID mountUUID = tag.m_128441_("MountUUID") ? tag.m_128342_("MountUUID") : null;
                UUID targetPlayerUUID = tag.m_128441_("TargetPlayerUUID") ? tag.m_128342_("TargetPlayerUUID") : null;
                HashSet<UUID> henchmenUUIDs = new HashSet<UUID>();
                ListTag henchmenList = tag.m_128437_("Henchmen", 10);
                for (int i = 0; i < henchmenList.size(); ++i) {
                    CompoundTag henchmanTag = henchmenList.m_128728_(i);
                    henchmenUUIDs.add(henchmanTag.m_128342_("UUID"));
                }
                int spawnTimer = tag.m_128451_("SpawnTimer");
                int totalSpawned = tag.m_128451_("TotalSpawned");
                boolean isActive = tag.m_128471_("IsActive");
                boolean bossConfirmed = tag.m_128471_("BossConfirmed");
                return new ActiveRaidData(raidId, configRaidId, raidLevel, spawnCenter, startTime, bossUUID, mountUUID, targetPlayerUUID, henchmenUUIDs, spawnTimer, totalSpawned, isActive, bossConfirmed);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load active raid data: {}", (Object)e.getMessage());
                return null;
            }
        }
    }

    public record ScheduledRaidData(ResourceLocation dimension, UUID targetPlayerUUID, String raidId, long scheduledDay) {
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Dimension", this.dimension.toString());
            tag.m_128362_("PlayerUUID", this.targetPlayerUUID);
            tag.m_128359_("RaidId", this.raidId);
            tag.m_128356_("ScheduledDay", this.scheduledDay);
            return tag;
        }

        @Nullable
        public static ScheduledRaidData load(CompoundTag tag) {
            try {
                ResourceLocation dimension = new ResourceLocation(tag.m_128461_("Dimension"));
                UUID playerUUID = tag.m_128342_("PlayerUUID");
                String raidId = tag.m_128461_("RaidId");
                long scheduledDay = tag.m_128454_("ScheduledDay");
                return new ScheduledRaidData(dimension, playerUUID, raidId, scheduledDay);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load scheduled raid data: {}", (Object)e.getMessage());
                return null;
            }
        }
    }
}

