/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;

public class ThrowableGrenadeEntity
extends ThrowableItemEntity {
    public float rotation;
    public float prevRotation;
    private float explosionRadius = 2.5f;
    private float explosionDamage = 19.0f;

    public ThrowableGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, Level world, LivingEntity entity) {
        super(entityType, world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((ItemLike)ModItems.GRENADE.get()));
        this.setMaxLife(4);
    }

    public ThrowableGrenadeEntity(Level world, LivingEntity entity, int timeLeft) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_GRENADE.get()), world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((ItemLike)ModItems.GRENADE.get()));
        this.setMaxLife(timeLeft);
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public float getExplosionDamage() {
        return this.explosionDamage;
    }

    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRotation = this.rotation;
        double speed = this.m_20184_().m_82553_();
        this.particleTick();
    }

    public void particleTick() {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onDeath() {
        ProjectileEntity.createRocketExplosion((Entity)this, this.explosionRadius, this.explosionDamage, false);
    }
}

