/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.blockentity.MineUnitBlockEntity;
import top.ribs.scguns.init.ModTags;

public class MetalDetectorItem
extends Item {
    private static final int DETECTION_RADIUS = 16;
    private static final int COOLDOWN_TICKS = 30;
    private static final double BASE_PULL_STRENGTH = 0.5;
    private static final double MAX_PULL_STRENGTH = 1.3;

    public MetalDetectorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos nearestMetal = this.findNearestMetal(level, player.m_20183_());
        if (nearestMetal != null) {
            if (!level.f_46443_) {
                double distance = Math.sqrt(player.m_20183_().m_123331_((Vec3i)nearestMetal));
                this.pullPlayerToward(player, nearestMetal, distance);
                this.spawnTargetHint((ServerLevel)level, nearestMetal);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 0.5f, 1.0f + (float)(distance / 16.0) * 0.5f);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            player.m_36335_().m_41524_((Item)this, 30);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (level.f_46443_) {
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_11797_, SoundSource.PLAYERS, 0.3f, 0.8f);
        }
        player.m_36335_().m_41524_((Item)this, 15);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private void spawnTargetHint(ServerLevel level, BlockPos targetPos) {
        BlockState state = level.m_8055_(targetPos);
        boolean isMine = level.m_7702_(targetPos) instanceof MineUnitBlockEntity;
        double baseY = isMine ? (double)targetPos.m_123342_() + 0.5 : (double)targetPos.m_123342_() + 1.0;
        int particleCount = isMine ? 3 : 2;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (double)targetPos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.3;
            double offsetY = baseY + level.f_46441_.m_188500_() * 0.1;
            double offsetZ = (double)targetPos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.3;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, offsetX, offsetY, offsetZ, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 0;
    }

    @Nullable
    private BlockPos findNearestMetal(Level level, BlockPos playerPos) {
        BlockPos nearestPos = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    double distSq;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (!state.m_204336_(ModTags.Blocks.METAL_DETECTABLE) || !((distSq = playerPos.m_123331_((Vec3i)checkPos)) < nearestDistSq)) continue;
                    nearestDistSq = distSq;
                    nearestPos = checkPos;
                }
            }
        }
        return nearestPos;
    }

    private void pullPlayerToward(Player player, BlockPos targetPos, double distance) {
        Vec3 playerPos = player.m_20182_();
        Vec3 targetVec = Vec3.m_82512_((Vec3i)targetPos);
        Vec3 direction = targetVec.m_82546_(playerPos).m_82541_();
        double pullStrength = 0.5 + 0.8 * (1.0 - Math.min(distance / 16.0, 1.0));
        Vec3 velocity = direction.m_82490_(pullStrength);
        player.m_20256_(player.m_20184_().m_82549_(velocity));
        player.f_19864_ = true;
    }
}

