/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.MagnetDim;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeMagnet;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UpgradeData
extends BlockEntityDataShim {
    protected final ItemStack[] upgrades;
    private int storageMultiplier;
    private int[] magnetRange;
    private int magnetActiveRate;
    private int magnetIdleRate;
    private EnumUpgradeRedstone redstoneType;
    private boolean hasOneStack;
    private boolean hasVoid;
    private boolean hasUnlimited;
    private boolean hasVending;
    private boolean hasConversion;
    private boolean hasIllumination;
    private boolean hasFillLevel;
    private boolean hasBalanceFill;
    private boolean hasHopper;
    private boolean hasMagnet;
    private boolean hasRemote;
    private IDrawerAttributesModifiable attrs;

    public UpgradeData(int slotCount) {
        this.upgrades = new ItemStack[slotCount];
        Arrays.fill(this.upgrades, ItemStack.f_41583_);
        this.syncStorageMultiplier();
        this.syncMagnetRange();
    }

    public void setDrawerAttributes(IDrawerAttributesModifiable attrs) {
        this.attrs = attrs;
        this.syncUpgrades();
    }

    public int getSlotCount() {
        return this.upgrades.length;
    }

    @NotNull
    public ItemStack getUpgrade(int slot) {
        slot = Mth.m_14045_((int)slot, (int)0, (int)(this.upgrades.length - 1));
        return this.upgrades[slot];
    }

    public boolean hasEmptySlot() {
        return this.getNextUpgradeSlot() != -1;
    }

    public boolean addUpgrade(@NotNull ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public boolean setUpgrade(int slot, @NotNull ItemStack upgrade) {
        ItemStack prevUpgrade;
        slot = Mth.m_14045_((int)slot, (int)0, (int)(this.upgrades.length - 1));
        if (!upgrade.m_41619_()) {
            upgrade = upgrade.m_41777_();
            upgrade.m_41764_(1);
        }
        if (!(prevUpgrade = this.upgrades[slot]).m_41619_() && !this.canRemoveUpgrade(slot)) {
            if (!(prevUpgrade.m_41720_() instanceof ItemUpgradeStorage)) {
                return false;
            }
            if (!(upgrade.m_41720_() instanceof ItemUpgradeStorage)) {
                return false;
            }
            ItemUpgradeStorage target = (ItemUpgradeStorage)prevUpgrade.m_41720_();
            ItemUpgradeStorage itemUpgradeStorage = (ItemUpgradeStorage)upgrade.m_41720_();
        }
        this.upgrades[slot] = ItemStack.f_41583_;
        this.syncStorageMultiplier();
        if (!upgrade.m_41619_() && !this.canAddUpgrade(upgrade)) {
            this.upgrades[slot] = prevUpgrade;
            this.syncStorageMultiplier();
            return false;
        }
        this.upgrades[slot] = upgrade;
        this.syncUpgrades();
        this.onUpgradeChanged(prevUpgrade, upgrade);
        return true;
    }

    public boolean canAddUpgrade(@NotNull ItemStack upgrade) {
        if (upgrade.m_41619_()) {
            return false;
        }
        ItemStack[] itemStackArray = upgrade.m_41720_();
        if (!(itemStackArray instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)itemStackArray;
        if (!candidate.isEnabled()) {
            return false;
        }
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (ItemStack stack : this.upgrades) {
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemUpgrade)) continue;
            ItemUpgrade reference = (ItemUpgrade)item;
            if (candidate.getUpgradeGroup() != reference.getUpgradeGroup()) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveUpgrade(int slot) {
        return !this.upgrades[slot = Mth.m_14045_((int)slot, (int)0, (int)(this.upgrades.length - 1))].m_41619_();
    }

    public boolean canSwapUpgrade(int slot, @NotNull ItemStack add) {
        return this.canAddUpgrade(add) && this.canRemoveUpgrade(slot);
    }

    public int getStorageMultiplier() {
        return this.storageMultiplier;
    }

    public int getMagnetRange(MagnetDim dim) {
        return switch (dim) {
            default -> throw new IncompatibleClassChangeError();
            case MagnetDim.HORIZONTAL -> this.magnetRange[0];
            case MagnetDim.UP -> this.magnetRange[1];
            case MagnetDim.DOWN -> this.magnetRange[2];
        };
    }

    public int getMagnetActiveRate() {
        return this.magnetActiveRate;
    }

    public int getMagnetIdleRate() {
        return this.magnetIdleRate;
    }

    public EnumUpgradeRedstone getRedstoneType() {
        return this.redstoneType;
    }

    public boolean hasOneStackUpgrade() {
        return this.hasOneStack;
    }

    public boolean hasUnlimitedUpgrade() {
        return this.hasUnlimited;
    }

    public boolean hasVendingUpgrade() {
        return this.hasVending;
    }

    public boolean hasConversionUpgrade() {
        return this.hasConversion;
    }

    public boolean hasIlluminationUpgrade() {
        return this.hasIllumination;
    }

    public boolean hasbalancedFillUpgrade() {
        return this.hasBalanceFill;
    }

    public boolean hasHopperUpgrade() {
        return this.hasHopper;
    }

    public boolean hasMagnetUpgrade() {
        return this.hasMagnet;
    }

    public boolean hasRemoteUpgrade() {
        return this.hasRemote;
    }

    public boolean hasPortabilityUpgrade() {
        for (ItemStack stack : this.upgrades) {
            if (stack.m_41720_() != ModItems.PORTABILITY_UPGRADE.get()) continue;
            return true;
        }
        return false;
    }

    private int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getRemoteUpgrade() {
        if (!this.hasRemote) {
            return null;
        }
        for (ItemStack stack : this.upgrades) {
            if (!(stack.m_41720_() instanceof ItemUpgradeRemote)) continue;
            return stack;
        }
        return null;
    }

    public void unbindRemoteUpgrade() {
        if (!this.hasRemote) {
            return;
        }
        for (int i = 0; i < this.upgrades.length; ++i) {
            ItemUpgradeRemote remote;
            ItemStack stack = this.upgrades[i];
            Item item = stack.m_41720_();
            if (!(item instanceof ItemUpgradeRemote) || !(remote = (ItemUpgradeRemote)item).isBound()) continue;
            this.upgrades[i] = ItemUpgradeRemote.setUnbound(stack);
            this.onUpgradeChanged(stack, this.upgrades[i]);
        }
    }

    public void updateRemoteUpgradeBinding(ItemStack refStack) {
        if (!this.hasRemote || refStack == null) {
            return;
        }
        for (int i = 0; i < this.upgrades.length; ++i) {
            ItemStack stack = this.upgrades[i];
            if (!(stack.m_41720_() instanceof ItemUpgradeRemote)) continue;
            this.upgrades[i] = ItemUpgradeRemote.copyControllerBinding(refStack, this.upgrades[i]);
            this.onUpgradeChanged(stack, this.upgrades[i]);
        }
    }

    private void syncUpgrades() {
        if (this.attrs == null) {
            return;
        }
        this.syncStorageMultiplier();
        this.syncRedstoneLevel();
        this.syncMagnetRange();
        this.hasOneStack = false;
        this.hasVoid = false;
        this.hasUnlimited = false;
        this.hasVending = false;
        this.hasConversion = false;
        this.hasIllumination = false;
        this.hasFillLevel = false;
        this.hasBalanceFill = false;
        this.hasHopper = false;
        this.hasRemote = false;
        for (ItemStack stack : this.upgrades) {
            Item item = stack.m_41720_();
            if (item == ModItems.ONE_STACK_UPGRADE.get()) {
                this.hasOneStack = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.oneStackUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.VOID_UPGRADE.get()) {
                this.hasVoid = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.voidUgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.CONVERSION_UPGRADE.get()) {
                this.hasConversion = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.CREATIVE_STORAGE_UPGRADE.get()) {
                this.hasUnlimited = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.creativeStorageUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.CREATIVE_VENDING_UPGRADE.get()) {
                this.hasVending = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.creativeVendingUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.ILLUMINATION_UPGRADE.get()) {
                this.hasIllumination = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.FILL_LEVEL_UPGRADE.get()) {
                this.hasFillLevel = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.fillLevelUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.BALANCE_FILL_UPGRADE.get()) {
                this.hasBalanceFill = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.balanceUpgrade.enableUpgrade.get();
                continue;
            }
            if (item == ModItems.HOPPER_UPGRADE.get()) {
                this.hasHopper = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.hopperUpgrade.enableUpgrade.get();
                continue;
            }
            if (!(item instanceof ItemUpgradeRemote)) continue;
            ItemUpgradeRemote remote = (ItemUpgradeRemote)item;
            boolean enable = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.remoteUpgrade.enableUpgrade.get();
            this.hasRemote = remote.isGroupUpgrade() ? ((Boolean)ModCommonConfig.INSTANCE.UPGRADES.remoteUpgrade.enableGroup.get()).booleanValue() && enable : enable;
        }
        this.attrs.setIsVoid(this.hasVoid);
        this.attrs.setHasFillLevel(this.hasFillLevel);
        this.attrs.setIsDictConvertible(this.hasConversion);
        this.attrs.setIsUnlimitedStorage(this.hasUnlimited);
        this.attrs.setIsUnlimitedVending(this.hasVending);
        this.attrs.setIsBalancedFill(this.hasBalanceFill);
        this.attrs.setIsHopper(this.hasHopper);
        this.attrs.setIsMagnet(this.hasMagnet);
    }

    private void syncStorageMultiplier() {
        this.storageMultiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.m_41720_() instanceof ItemUpgradeStorage)) continue;
            int level = ((ItemUpgradeStorage)stack.m_41720_()).level.getLevel();
            this.storageMultiplier += ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(level);
        }
        if (this.storageMultiplier == 0) {
            this.storageMultiplier = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(0);
        }
    }

    private void syncMagnetRange() {
        if (this.magnetRange == null || this.magnetRange.length != 3) {
            this.magnetRange = new int[3];
        }
        Arrays.fill(this.magnetRange, 0);
        this.hasMagnet = false;
        int highestTier = 0;
        for (ItemStack stack : this.upgrades) {
            ItemUpgradeMagnet itemMagnet;
            Item item = stack.m_41720_();
            if (!(item instanceof ItemUpgradeMagnet) || !(itemMagnet = (ItemUpgradeMagnet)item).isEnabled()) continue;
            this.hasMagnet = true;
            if (((Boolean)ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.additiveRange.get()).booleanValue()) {
                this.magnetRange[0] = this.magnetRange[0] + itemMagnet.getHorzRange();
                this.magnetRange[1] = this.magnetRange[1] + itemMagnet.getUpRange();
                this.magnetRange[2] = this.magnetRange[2] + itemMagnet.getDownRange();
            } else {
                this.magnetRange[0] = this.magnetRange[0] + Math.max(this.magnetRange[0], itemMagnet.getHorzRange());
                this.magnetRange[1] = this.magnetRange[1] + Math.max(this.magnetRange[1], itemMagnet.getUpRange());
                this.magnetRange[2] = this.magnetRange[2] + Math.max(this.magnetRange[2], itemMagnet.getDownRange());
            }
            if (itemMagnet.type.getLevel() <= highestTier) continue;
            highestTier = itemMagnet.type.getLevel();
            this.magnetActiveRate = itemMagnet.getActiveSpeed();
            this.magnetIdleRate = itemMagnet.getIdleSpeed();
        }
        List maxRange = (List)ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.maxRange.get();
        int n = Math.min(maxRange.size(), this.magnetRange.length);
        for (int i = 0; i < n; ++i) {
            this.magnetRange[i] = Math.min(this.magnetRange[i], (Integer)maxRange.get(i));
        }
    }

    private void syncRedstoneLevel() {
        this.redstoneType = null;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.m_41720_() instanceof ItemUpgradeRedstone)) continue;
            this.redstoneType = ((ItemUpgradeRedstone)stack.m_41720_()).type;
            break;
        }
    }

    @Override
    public void read(CompoundTag tag) {
        Arrays.fill(this.upgrades, ItemStack.f_41583_);
        if (!tag.m_128441_("Upgrades")) {
            return;
        }
        ListTag tagList = tag.m_128437_("Upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag upgradeTag = tagList.m_128728_(i);
            byte slot = upgradeTag.m_128445_("Slot");
            this.upgrades[slot] = ItemStack.m_41712_((CompoundTag)upgradeTag);
        }
        this.syncUpgrades();
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i].m_41619_()) continue;
            CompoundTag upgradeTag = this.upgrades[i].m_41739_(new CompoundTag());
            upgradeTag.m_128344_("Slot", (byte)i);
            tagList.add((Object)upgradeTag);
        }
        tag.m_128365_("Upgrades", (Tag)tagList);
        return tag;
    }

    protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
    }
}

