/*
 * Decompiled with CFR 0.152.
 */
package com.tameable.tameablefoxes.entity;

import com.tameable.tameablefoxes.TameableFoxes;
import com.tameable.tameablefoxes.event.FollowOwnerGoalCustom;
import com.tameable.tameablefoxes.event.OwnerHurtByTargetGoalCustom;
import com.tameable.tameablefoxes.event.OwnerHurtTargetGoalCustom;
import com.tameable.tameablefoxes.event.SitGoalCustom;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public class TameableFox
extends Fox {
    private UUID ownerUUID;
    private int collarColor = DyeColor.RED.m_41060_();
    private long lastSitToggleTick = -20L;
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(TameableFox.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.m_135353_(TameableFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(TameableFox.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public TameableFox(EntityType<? extends Fox> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public int getCollarColor() {
        return (Integer)this.f_19804_.m_135370_(COLLAR_COLOR);
    }

    public void setCollarColor(int color) {
        this.f_19804_.m_135381_(COLLAR_COLOR, (Object)color);
    }

    public static AttributeSupplier.Builder m_28553_() {
        AttributeSupplier.Builder builder = Fox.m_28553_();
        builder.m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 2.0);
        TameableFox.addOptionalAttribute(builder, "caelus:elytra_flight");
        TameableFox.addOptionalAttribute(builder, "attributeslib:elytra_flight");
        TameableFox.addOptionalAttribute(builder, "tconstruct:generic.jump_boost");
        TameableFox.addOptionalAttribute(builder, "forge:swim_speed");
        TameableFox.addOptionalAttribute(builder, "forge:reach_distance");
        return builder;
    }

    private static void addOptionalAttribute(AttributeSupplier.Builder builder, String id) {
        ResourceLocation rl = new ResourceLocation(id);
        Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(rl);
        if (attr != null) {
            builder.m_22266_(attr);
            System.out.println("[TameableFoxes] Added optional attribute: " + id);
        } else {
            System.out.println("[TameableFoxes] Skipping unknown attribute: " + id);
        }
    }

    public boolean canToggleSit(long currentTick) {
        if (currentTick - this.lastSitToggleTick >= 10L) {
            this.lastSitToggleTick = currentTick;
            return true;
        }
        return false;
    }

    public boolean isSleepingCustom() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleepingCustom(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_5803_() {
        return this.isSleepingCustom();
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.ownerUUID == null) {
            return null;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            LivingEntity living;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.m_8791_(this.ownerUUID);
            return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        }
        return null;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag dataTag) {
        SpawnGroupData result = super.m_6518_(level, difficulty, spawnType, spawnGroupData, dataTag);
        this.m_21530_();
        if (this.m_28554_() == null) {
            this.m_28464_(((ResourceKey)level.m_204166_(this.m_20183_()).m_203543_().get()).m_135782_().m_135815_().contains("snow") ? Fox.Type.SNOW : Fox.Type.RED);
        }
        this.setSleepingCustom(false);
        return result;
    }

    public boolean m_6898_(ItemStack stack) {
        return this.isTamed() && stack.m_150930_(Items.f_42780_);
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof TameableFox)) {
            return false;
        }
        TameableFox otherFox = (TameableFox)otherAnimal;
        if (this.m_6162_() || otherAnimal.m_6162_()) {
            return false;
        }
        return this.isTamed() && otherFox.isTamed() && this.m_27593_() && otherFox.m_27593_();
    }

    public Fox m_142606_(ServerLevel level, AgeableMob partner) {
        TameableFox baby = (TameableFox)((EntityType)TameableFoxes.TAMEABLE_FOX.get()).m_20615_((Level)level);
        if (baby == null) {
            return null;
        }
        baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_());
        Fox.Type type = this.f_19796_.m_188499_() ? this.m_28554_() : ((Fox)partner).m_28554_();
        baby.m_28464_(type);
        baby.setTamed(true);
        baby.setOwnerUUID(this.getOwnerUUID());
        baby.setCollarColor(this.getCollarColor());
        baby.m_146762_(-24000);
        return baby;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_() instanceof ServerLevel && this.m_6162_()) {
            this.m_146762_(this.m_146764_() + 1);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Tamed", this.isTamed());
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128405_("CollarColor", this.getCollarColor());
        tag.m_128379_("Sleeping", this.isSleepingCustom());
        tag.m_128405_("Age", this.m_146764_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Tamed")) {
            this.setTamed(tag.m_128471_("Tamed"));
        }
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("CollarColor")) {
            this.setCollarColor(tag.m_128451_("CollarColor"));
        }
        if (tag.m_128441_("Sleeping")) {
            this.setSleepingCustom(tag.m_128471_("Sleeping"));
        }
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitGoalCustom(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoalCustom(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoalCustom(this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoalCustom(this));
    }
}

