/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.block.XKDStateProperties;
import snownee.kiwi.customization.block.BasicBlock;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.util.NotNullByDefault;
import snownee.kiwi.util.Util;

@NotNullByDefault
public class AirDuctBlock
extends BasicBlock {
    public AirDuctBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        BlockState blockState = (BlockState)this.f_49792_.m_61090_();
        for (BooleanProperty property : XKDStateProperties.DIRECTION_PROPERTIES) {
            blockState = (BlockState)blockState.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        XKDStateProperties.DIRECTION_PROPERTIES.forEach(xva$0 -> pBuilder.m_61104_(new Property[]{xva$0}));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        BlockState newState = pState;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean value = (Boolean)pState.m_61143_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(direction.m_122411_()));
            newState = (BlockState)newState.m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(pRotation.m_55954_(direction).m_122411_()), (Comparable)Boolean.valueOf(value));
        }
        return newState;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        BlockState newState = pState;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean value = (Boolean)pState.m_61143_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(direction.m_122411_()));
            newState = (BlockState)newState.m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(pMirror.m_54848_(direction).m_122411_()), (Comparable)Boolean.valueOf(value));
        }
        return newState;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pPlayer.m_21206_().m_150930_(Items.f_42464_)) {
            return InteractionResult.PASS;
        }
        Direction direction = pHit.m_82434_();
        pState = (BlockState)pState.m_61122_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(direction.m_122411_()));
        pLevel.m_46597_(pPos, pState);
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        ArrayList neighbors = Lists.newArrayList();
        for (Direction direction : Util.DIRECTIONS) {
            BlockState neighborState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction));
            if (!AirDuctBlock.isAirDuctSlot(neighborState, direction.m_122424_())) continue;
            neighbors.add(direction);
        }
        BlockState blockState = this.m_49966_();
        if (neighbors.size() < 2) {
            Direction face = neighbors.isEmpty() ? pContext.m_43719_() : (Direction)neighbors.get(0);
            return (BlockState)((BlockState)blockState.m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(face.m_122411_()), (Comparable)Boolean.valueOf(true))).m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(face.m_122424_().m_122411_()), (Comparable)Boolean.valueOf(true));
        }
        for (Direction direction : neighbors) {
            blockState = (BlockState)blockState.m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(direction.m_122411_()), (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    public BlockState m_7417_(BlockState blockState, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos pos, BlockPos pNeighborPos) {
        if (!AirDuctBlock.isAirDuctSlot(pNeighborState, pDirection.m_122424_())) {
            return blockState;
        }
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        ArrayList neighbors = Lists.newArrayListWithExpectedSize((int)2);
        for (Direction direction : Util.DIRECTIONS) {
            BlockState neighborState;
            if (direction == pDirection || !AirDuctBlock.isAirDuctSlot(neighborState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction)), direction.m_122424_())) continue;
            neighbors.add(direction);
            if (neighbors.size() < 2) continue;
            return (BlockState)blockState.m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(pDirection.m_122411_()), (Comparable)Boolean.valueOf(true));
        }
        Direction theOtherDirection = neighbors.isEmpty() ? pDirection.m_122424_() : (Direction)neighbors.get(0);
        for (Direction direction : Util.DIRECTIONS) {
            blockState = (BlockState)blockState.m_61124_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(direction.m_122411_()), (Comparable)Boolean.valueOf(direction == pDirection || direction == theOtherDirection));
        }
        return blockState;
    }

    public static boolean isAirDuctSlot(BlockState blockState, Direction side) {
        return PlaceSlot.find((BlockState)blockState, (Direction)side, (String)"*xkdeco.air_duct").isPresent();
    }
}

