/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.SegmentedAnglePrecision;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.block.DisplayBlock;
import org.teacon.xkdeco.blockentity.ItemDisplayBlockEntity;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ItemDisplayBlock
extends DisplayBlock {
    private static final SegmentedAnglePrecision SEGMENTED_ANGLE8 = new SegmentedAnglePrecision(3);
    private static final float angleStep = (float)Math.PI * 5;
    public static final MapCodec<ItemDisplayBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockCodecs.propertiesCodec(), (App)Codec.BOOL.optionalFieldOf("projector", (Object)false).forGetter(block -> block.projector)).apply((Applicative)instance, ItemDisplayBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public final boolean projector;

    public ItemDisplayBlock(BlockBehaviour.Properties properties, boolean projector) {
        super(properties);
        this.projector = projector;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ItemDisplayBlockEntity(pPos, pState, this.projector);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_276867_(pContext.m_8083_())));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.f_46443_ && ((Boolean)pState.m_61143_((Property)POWERED)).booleanValue() != pLevel.m_276867_(pPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        }
    }

    @Override
    protected InteractionResult useSide(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof ItemDisplayBlockEntity) {
            ItemDisplayBlockEntity blockEntity2 = (ItemDisplayBlockEntity)blockEntity;
            blockEntity2.setFixedSpin(blockEntity2.getSpin() + (float)Math.PI * 5);
            blockEntity2.refresh();
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    @Override
    protected InteractionResult useTop(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        this.setSpin(pLevel, pPos, (LivingEntity)pPlayer);
        return super.useTop(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private void setSpin(Level level, BlockPos pos, @Nullable LivingEntity placer) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && placer != null && (blockEntity = level.m_7702_(pos)) instanceof ItemDisplayBlockEntity) {
            ItemDisplayBlockEntity be = (ItemDisplayBlockEntity)blockEntity;
            be.setFixedSpin(SEGMENTED_ANGLE8.m_264138_(SEGMENTED_ANGLE8.m_264419_(-placer.m_146908_() - 180.0f)) / 45.0f * ((float)Math.PI * 5));
        }
    }

    @Override
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.setSpin(pLevel, pPos, pPlacer);
    }
}

