/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.block.XKDStateProperties;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class RoofRidgeBlock
extends WallBlock {
    public static final Map<Direction, EnumProperty<WallSide>> DIRECTION_TO_PROPERTY = Map.of(Direction.NORTH, WallBlock.f_57951_, Direction.EAST, WallBlock.f_57950_, Direction.SOUTH, WallBlock.f_57952_, Direction.WEST, WallBlock.f_57953_);

    public RoofRidgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(fluidState.m_192917_((Fluid)Fluids.f_76193_)));
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        WallSide[] wallSides = new WallSide[4];
        boolean hasTall = false;
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide;
            mutable.m_122159_((Vec3i)pos, direction);
            BlockState offsetBlock = level.m_8055_((BlockPos)mutable);
            wallSides[i] = wallSide = RoofRidgeBlock.makeSide((LevelReader)level, (BlockPos)mutable, offsetBlock, direction);
            if (wallSide == WallSide.TALL) {
                hasTall = true;
            }
            ++i;
        }
        i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide = wallSides[i];
            if (wallSide == null) {
                wallSide = hasTall ? WallSide.TALL : WallSide.LOW;
            }
            EnumProperty<WallSide> property = DIRECTION_TO_PROPERTY.get(direction);
            blockState = (BlockState)blockState.m_61124_(property, (Comparable)wallSide);
            ++i;
        }
        return blockState;
    }

    @Nullable
    public static WallSide makeSide(LevelReader level, BlockPos pos, BlockState offsetBlock, Direction direction) {
        if (offsetBlock.m_60734_().getClass() == RoofRidgeBlock.class) {
            Direction direction1 = direction.m_122424_();
            for (int j = 0; j < 4; ++j) {
                WallSide wallSide = (WallSide)offsetBlock.m_61143_((Property)DIRECTION_TO_PROPERTY.get(direction1));
                if (wallSide != WallSide.NONE) {
                    return wallSide;
                }
                direction1 = direction1.m_122427_();
            }
            return WallSide.LOW;
        }
        if (offsetBlock.m_61138_((Property)XKDStateProperties.ROOF_VARIANT_WITHOUT_SLOW) && PlaceSlot.find((BlockState)offsetBlock, (Direction)direction.m_122424_(), (String)"*roof_ridge_end").isPresent()) {
            return "steep".equals(offsetBlock.m_61143_((Property)XKDStateProperties.ROOF_VARIANT_WITHOUT_SLOW)) ? WallSide.TALL : WallSide.LOW;
        }
        if (!Block.m_152463_((BlockState)offsetBlock) && offsetBlock.m_60783_((BlockGetter)level, pos, direction.m_122424_())) {
            return null;
        }
        return WallSide.NONE;
    }
}

